/* engine.c: Miscellaneous platform-independent code

Known bugs:
 * off-by-one-frame error for recording vs. playback of REA files (and
   probably INR/EAR also), ie. input events seem to be played back one
   frame too early or late. JTRON illustrates this bug most readily.
   All versions of Ami/WinArcadia seem to have this bug.

INCLUDES--------------------------------------------------------------- */

#ifdef AMIGA
    #include "lint.h"
    #include "amiga.h"
#endif
#ifdef WIN32
    #include "ibm.h"
#endif

#include <stdio.h>             // for printf()
#include <stdlib.h>            // for malloc(), free()
#include <string.h>            // for strcpy(), etc.

#include "aa.h"

#ifdef AMIGA
    #include <intuition/intuition.h>
    #define ALL_REACTION_CLASSES
    #define ALL_REACTION_MACROS
    #include <reaction/reaction.h>
    #include <proto/gadtools.h>
    #include <proto/intuition.h>
#endif
#ifdef WIN32
    #include <commctrl.h>
    #include "resource.h"
#endif

// DEFINES----------------------------------------------------------------

// bitfield
#define NOREAD       1
#define NOWRITE      2
#define READONCE     4
#define AUDIBLE      8
#define MIRRORED_R  16
#define MIRRORED_W  32

#define FUDGE      267

// MODULE VARIABLES-------------------------------------------------------

MODULE UBYTE  memflags[32768],
              t;
MODULE TEXT   astring[4 + 1],
              bits[4][10][8 + 1],
              bstring[3 + 1],
              disp[16][4 + 1],
              xvistring[3][10 + 1];
MODULE UWORD  mirror_r[32768], // resolved read  addresses
              mirror_w[32768]; // resolved write addresses
MODULE int    filesize,
              whichgame        = -1;
MODULE ULONG  crcTable[256];
MODULE FLAG   golf;

// EXPORTED VARIABLES-----------------------------------------------------

// variables which correspond to ReAction gadgets must be ULONGs
EXPORT ULONG  analog           = FALSE,
              autofire         = FALSE,
              collisions       = TRUE,
              swapped          = FALSE,
              demultiplex      = FALSE,
              flagline         = TRUE,
              joy1             = FALSE,
              paused           = FALSE,
              region           = REGION_NTSC,
              sound            = TRUE,
              vlock            = FALSE,
              warp             = FALSE;
// other ULONGs go here
EXPORT ULONG  downframes       = 4,
              oldframes,
              frames,
              totalframes      = 16;
EXPORT TEXT   friendly[21 + 1],
           // "$19FD (SPRITECOLLIDE)"
           //  0123456789012345678901
              timestring[11 + 1], // "hh:mm:ss.uu"
              fromstr[5 + 1 + 1],
              filepart[MAX_PATH + 1],
              pathpart[MAX_PATH + 1],
              thefilename[MAX_PATH + 1] = "", // the entire pathname (path and file)
              tostr[5 + 1 + 1];
EXPORT FILE*  MacroHandle      = NULL;
EXPORT int    bp               = OUTOFRANGE,
              cpl              = PVI_CPL,
              frameskip        = 1,
              fromnum,
              fudge            = FUDGE,
              machine          = ARCADIA,
              memmap,
              offset,
              primary          = 2; // probably doesn't need initialization here
              rast,
              rastn            = -1,
              recmode          = RECMODE_NORMAL,
              recsize,
              romsize,
              sensegame        = SENSEGAME_QUIET,
              size             = 1,
              tonum,
              tolimit,
              wide             = 2,
              wp               = OUTOFRANGE;
EXPORT FLAG   autosave         = TRUE,
              consoleopen      = FALSE,
              crippled         = FALSE,
              emulating        = FALSE,
              fullscreen       = FALSE,
              game             = FALSE,
              icons            = FALSE,
              inframe          = FALSE,
              limitrefresh     = FALSE,
              loginstructions  = FALSE,
              logreads         = FALSE,
              logwrites        = FALSE,
              loop             = TRUE,
              runtorastline    = FALSE,
              runtodma         = FALSE,
              runtoframe       = FALSE,
			  showmenubar      = TRUE,
              showtitlebar     = TRUE,
              showtoolbar      = TRUE,
              showpointer      = TRUE,
              stretch          = TRUE,
              trace            = FALSE,
              usehacks         = TRUE,
              watchreads       = FALSE;
EXPORT SLONG  ax[2], // analog paddle X-coords
              ay[2]; // analog paddle Y-coords
EXPORT UBYTE* IOBuffer      = NULL;

// IMPORTED VARIABLES-----------------------------------------------------

IMPORT ULONG  cycles,
              elapsed;
IMPORT FLAG   consoleopen,
              interrupt,
              step;
IMPORT UBYTE  psu,
              psl,
              r[7],
              memory[32768];
IMPORT UWORD  iar,
              i_spritedata[4],
              page, // page select register
              ras[8];
IMPORT int    overcalc;

#ifdef AMIGA
    IMPORT struct Gadget* gadgets[GIDS + 1];
    IMPORT struct Menu*   MenuPtr;
    IMPORT struct Window* MainWindowPtr;
    IMPORT UWORD          PointerData[6];
    IMPORT struct Screen* ScreenPtr;
    IMPORT Object*        smallimage[SMALLIMAGES];
#endif
#ifdef WIN32
    IMPORT HMENU          MenuPtr;
    IMPORT HWND           ControlsWindowPtr,
                          MonitorWindowPtr,
                          hToolbar;
    IMPORT int            titleheight,
                       /* wintopy, */
                          winleftx;
#endif

// MODULE STRUCTURES------------------------------------------------------

#define A_EQUIVALENTS          29 // counting from 1
MODULE struct
{   char*  text;
    UWORD  number;
} a_equivalents[A_EQUIVALENTS] = {
{ "P1PADDLE"     , A_P1PADDLE      }, //  0
{ "P2PADDLE"     , A_P2PADDLE      },
{ "SPRITECOLLIDE", A_SPRITECOLLIDE },
{ "BGCOLLIDE"    , A_BGCOLLIDE     },
{ "SPRITES01CTRL", A_SPRITES01CTRL },
{ "SPRITES23CTRL", A_SPRITES23CTRL }, //  5
{ "BGCOLOUR"     , A_BGCOLOUR      },
{ "RESOLUTION"   , A_RESOLUTION    },
{ "CONSOLE"      , A_CONSOLE       },
{ "P2PALLADIUM"  , A_P2PALLADIUM   },
{ "P2RIGHTKEYS"  , A_P2RIGHTKEYS   }, // 10
{ "P2MIDDLEKEYS" , A_P2MIDDLEKEYS  },
{ "P2LEFTKEYS"   , A_P2LEFTKEYS    },
{ "P1PALLADIUM"  , A_P1PALLADIUM   },
{ "P1RIGHTKEYS"  , A_P1RIGHTKEYS   },
{ "P1MIDDLEKEYS" , A_P1MIDDLEKEYS  }, // 15
{ "P1LEFTKEYS"   , A_P1LEFTKEYS    },
{ "CHARLINE"     , A_CHARLINE      },
{ "VOLUME"       , A_VOLUME        },
{ "PITCH"        , A_PITCH         },
{ "VSCROLL"      , A_VSCROLL       }, // 20
{ "SPRITE3X"     , A_SPRITE3X      },
{ "SPRITE3Y"     , A_SPRITE3Y      },
{ "SPRITE2X"     , A_SPRITE2X      },
{ "SPRITE2Y"     , A_SPRITE2Y      },
{ "SPRITE1X"     , A_SPRITE1X      }, // 25
{ "SPRITE1Y"     , A_SPRITE1Y      },
{ "SPRITE0X"     , A_SPRITE0X      },
{ "SPRITE0Y"     , A_SPRITE0Y      }  // 28
};

#define I_EQUIVALENTS          36 // counting from 1
MODULE struct
{   char*  text;
    UWORD  number;
} i_equivalents[I_EQUIVALENTS] = {
{ "P1PADDLE"     , I_P1PADDLE      }, //  0
{ "P2PADDLE"     , I_P2PADDLE      },
{ "SPRITECOLLIDE", I_SPRITECOLLIDE },
{ "BGCOLLIDE"    , I_BGCOLLIDE     },
{ "SPR01COLOURS" , I_SPR01COLOURS  },
{ "SPR23COLOURS" , I_SPR23COLOURS  }, //  5
{ "BGCOLOUR"     , I_BGCOLOUR      },
{ "CONSOLE"      , I_CONSOLE       },
{ "P2RIGHTKEYS"  , I_P2RIGHTKEYS   },
{ "P2MIDDLEKEYS" , I_P2MIDDLEKEYS  },
{ "P2LEFTKEYS"   , I_P2LEFTKEYS    }, // 10
{ "P1RIGHTKEYS"  , I_P1RIGHTKEYS   },
{ "P1MIDDLEKEYS" , I_P1MIDDLEKEYS  },
{ "P1LEFTKEYS"   , I_P1LEFTKEYS    },
{ "PITCH"        , I_PITCH         },
{ "SPRITE3AX"    , I_SPRITE3AX     }, // 15
{ "SPRITE3AY"    , I_SPRITE3AY     },
{ "SPRITE2AX"    , I_SPRITE2AX     },
{ "SPRITE2AY"    , I_SPRITE2AY     },
{ "SPRITE1AX"    , I_SPRITE1AX     },
{ "SPRITE1AY"    , I_SPRITE1AY     }, // 20
{ "SPRITE0AX"    , I_SPRITE0AX     },
{ "SPRITE0AY"    , I_SPRITE0AY     },
{ "SPRITE3BX"    , I_SPRITE3BX     },
{ "SPRITE3BY"    , I_SPRITE3BY     },
{ "SPRITE2BX"    , I_SPRITE2BX     }, // 25
{ "SPRITE2BY"    , I_SPRITE2BY     },
{ "SPRITE1BX"    , I_SPRITE1BX     },
{ "SPRITE1BY"    , I_SPRITE1BY     },
{ "SPRITE0BX"    , I_SPRITE0BX     },
{ "SPRITE0BY"    , I_SPRITE0BY     }, // 30
{ "SCORECTRL"    , I_SCORECTRL     },
{ "SCORELT"      , I_SCORELT       },
{ "SCORERT"      , I_SCORERT       },
{ "SIZES"        , I_SIZES         },
{ "NOISE"        , I_NOISE         }  // 35
// we don't support eg. HORIZGRID, as it is really just the start of a larger area.
};

#define E_EQUIVALENTS          32 // counting from 1
MODULE struct
{   char*  text;
    UWORD  number;
} e_equivalents[E_EQUIVALENTS] = {
{ "PITCHA1_L"    , E_PITCHA1_L     }, //  0
{ "PITCHA1_H"    , E_PITCHA1_H     },
{ "PITCHB1_L"    , E_PITCHB1_L     },
{ "PITCHB1_H"    , E_PITCHB1_H     },
{ "PITCHC1_L"    , E_PITCHC1_L     },
{ "PITCHC1_H"    , E_PITCHC1_H     }, //  5
{ "PITCHD1"      , E_PITCHD1       },
{ "ENABLE1"      , E_ENABLE1       },
{ "AMPLITUDEA1"  , E_AMPLITUDEA1   },
{ "AMPLITUDEB1"  , E_AMPLITUDEB1   },
{ "AMPLITUDEC1"  , E_AMPLITUDEC1   }, // 10
{ "PERIOD1_L"    , E_PERIOD1_L     },
{ "PERIOD1_H"    , E_PERIOD1_H     },
{ "SHAPE1"       , E_SHAPE1        },
{ "PORTA1"       , E_PORTA1        },
{ "PORTB1"       , E_PORTB1        }, // 15
{ "PITCHA2_L"    , E_PITCHA2_L     },
{ "PITCHA2_H"    , E_PITCHA2_H     },
{ "PITCHB2_L"    , E_PITCHB2_L     },
{ "PITCHB2_H"    , E_PITCHB2_H     },
{ "PITCHC2_L"    , E_PITCHC2_L     }, // 20
{ "PITCHC2_H"    , E_PITCHC2_H     },
{ "PITCHD2"      , E_PITCHD2       },
{ "ENABLE2"      , E_ENABLE2       },
{ "AMPLITUDEA2"  , E_AMPLITUDEA2   },
{ "AMPLITUDEB2"  , E_AMPLITUDEB2   }, // 25
{ "AMPLITUDEC2"  , E_AMPLITUDEC2   },
{ "PERIOD2_L"    , E_PERIOD2_L     },
{ "PERIOD2_H"    , E_PERIOD2_H     },
{ "SHAPE2"       , E_SHAPE2        },
{ "PORTA2"       , E_PORTA2        }, // 30
{ "PORTB2"       , E_PORTB2        }
// we don't support eg. RANDOM2, what is the point?
};

// known: all dumped ROMs, good and bad
// known: enhanced versions of games
// known: latest versions of homebrews
// known: ESS software (games and utilities)
// known: TVGC book programs
// not known: VIDLEX, VIDLEXE, VIDLEXG
// not known: examples
// not known: compatibility-patched versions of games
// not known: overdumps
// not known: trimmed dumps
// not known: old versions of homebrews
#define KNOWNGAMES 216 // yay!
#define GOLFPOS      0
MODULE struct
{   UBYTE  machine,
           memmap;
    ULONG  crc32;
    UBYTE  size,
           primary;
    FLAG   analog,
           autofire,
           demultiplex,
           swapped,
           bad,
           flagline;
    UBYTE  downframes,
           totalframes;
    SWORD  fudge;
    UBYTE  cpl;
    STRPTR name;
// We could conceivably want to also do joy1, vlock, warp, etc. in this manner.
} known[KNOWNGAMES] = {
// Emerson Arcadia 2001 family (58)
  { ARCADIA,         0, 0xA23C7A01,  6, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Golf"                                }, // GOLF (must be at GOLFPOS!)
  { ARCADIA,         0, 0xB0B98A92,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Soccer"                              }, // 2DSOCCER
  { ARCADIA,         0, 0x4DA68DF8,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "3D Soccer (Emerson version)"         }, // 3DSOCCEA
  { ARCADIA,         0, 0x1B5BE22A,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "3D Soccer (Tele-Fever version)"      }, // 3DSOCCEB
  { ARCADIA,         0, 0x1F65B21E,  4, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1, 16,   0,  0, "Alien Invaders"                      }, // ALIENINV
  { ARCADIA,         0, 0xDDCF5B2C,  4, 2, FALSE, TRUE , TRUE , FALSE, FALSE, TRUE,  1,  2,   0,  0, "Astro Invader"                       }, // ASTROINV
  { ARCADIA,         0, 0x99AC48CA,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Auto Race"                           }, // AUTORACE
  { ARCADIA,         0, 0x1CF08155,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Baseball"                            }, // BASEBALL
  { ARCADIA,         0, 0xE93938F6,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Basketball"                          }, // BASKETBA
  { ARCADIA,         0, 0x6818C8BD,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Battle"                              }, // BATTLE
  { ARCADIA,         0, 0x0930CE04,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Blackjack/Poker"                     }, // BLACKJAC
  { ARCADIA,         0, 0xF3C08E19,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "3D Bowling"                          }, // BOWLING
  { ARCADIA,         0, 0x9240891B,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Boxing"                              }, // BOXING
  { ARCADIA,         0, 0xCA58B3F8,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Brain Quiz"                          }, // BRAINQUI
  { ARCADIA,         0, 0x33C348C1,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Breakaway"                           }, // BREAKAWA
  { ARCADIA,         0, 0xAEB803E4,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Capture"                             }, // CAPTURE
  { ARCADIA,         0, 0xFD2CF496,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Cat Trax"                            }, // CATTRAX
  { ARCADIA,         0, 0x086EBC8C,  4, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Circus"                              }, // CIRCUS
  { ARCADIA,         0, 0xA6BFFA9E,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Combat"                              }, // COMBAT
  { ARCADIA,         0, 0x76E773FA,  4, 2, FALSE, FALSE, FALSE, TRUE , FALSE, TRUE,  4, 16,   0,  0, "Crazy Climber"                       }, // CRAZYCLI
  { ARCADIA,         0, 0xE84DF2EF,  2, 2, FALSE, FALSE, FALSE, TRUE , FALSE, TRUE,  4, 16,   0,  0, "Crazy Gobbler"                       }, // CRAZYGOB
  { ARCADIA,         0, 0x62C45881,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Doraemon"                            }, // DORAEMON
  { ARCADIA,         0, 0x927C375A,  8, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Dr. Slump"                           }, // DR-SLUMP
  { ARCADIA,         0, 0xFC7EBA76,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Escape"                              }, // ESCAPE
  { ARCADIA,         0, 0x77C19320,  8, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  4,  8,   0,  0, "Funky Fish"                          }, // FUNKFISH
  { ARCADIA,         0, 0x22624414,  6, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "American Football"                   }, // GRIDIRON
  { ARCADIA,         0, 0x1CEC4B21,  8, 2, FALSE, FALSE, FALSE, TRUE,  FALSE, TRUE,  4, 16,   0,  0, "Hobo"                                }, // HOBO
  { ARCADIA,         0, 0x560DAA7F,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Horse Racing"                        }, // HORSERAC
  { ARCADIA,         0, 0x97060A54,  8, 2, FALSE, TRUE , FALSE, TRUE , FALSE, TRUE,  1,  2,   0,  0, "Jump Bug (Emerson version)"          }, // JUMPBUGA
  { ARCADIA,         0, 0xDC0264B8,  8, 2, FALSE, TRUE , FALSE, TRUE , FALSE, TRUE,  1,  2,   0,  0, "Jump Bug (Tele-Fever version)"       }, // JUMPBUGB
  { ARCADIA,         0, 0xDFB5DD55,  8, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Jungler"                             }, // JUNGLER
  { ARCADIA,         0, 0x4C885AF2,  8, 2, FALSE, TRUE , TRUE , FALSE, FALSE, TRUE,  1,  2,   0,  0, "Super Dimension Fortress Macross"    }, // MACROSS
  { ARCADIA,         0, 0xA615F068,  4, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Missile War"                         }, // MISSILEW
  { ARCADIA,         0, 0x5E033F9C,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Monaco Grand Prix"                   }, // MONACO
  { ARCADIA,         0, 0x7832F7AD,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Nibblemen"                           }, // NIBBLE
  { ARCADIA,         0, 0x4F538848,  4, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1,  3,   0,  0, "Parashooter"                         }, // PARASHOO
  { ARCADIA,         0, 0x449E80CB,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Ocean Battle"                        }, // OCEANBAT
  { ARCADIA,         0, 0x4F19FD9B,  8, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1,  2,   0,  0, "Pleiades"                            }, // PLEIADES
  { ARCADIA,         0, 0xA0626E23,  4, 2, FALSE, FALSE, TRUE , TRUE , FALSE, TRUE,  1,  4,   0,  0, "R2D Tank"                            }, // R2DTANK
  { ARCADIA,         0, 0xA06F284B,  4, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "Red Clash"                           }, // REDCLASH
  { ARCADIA,         0, 0x4671B7F7,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Robot Killer"                        }, // ROBOTKIL
  { ARCADIA,         0, 0x8169864E,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Route 16"                            }, // ROUTE16
  { ARCADIA,         0, 0xE3794A2C,  4, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "Space Attack (Emerson version)"      }, // SATTACKA
  { ARCADIA,         0, 0x669632EC,  2, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "Space Attack (unknown version)"      }, // SATTACKB
  { ARCADIA,         0, 0xC91828CB,  2, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "Space War (prototype)"               }, // SATTACKC
  { ARCADIA,         0, 0x3FF224E5,  4, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Space Mission"                       }, // SMISSION
  { ARCADIA,         0, 0xBB88DAEA,  4, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "Spiders"                             }, // SPIDERS
  { ARCADIA,         0, 0x88DEFACF,  4, 2, FALSE, TRUE , TRUE , FALSE, FALSE, TRUE,  1,  2,   0,  0, "Space Raiders"                       }, // SRAIDERS
  { ARCADIA,         0, 0xCAA5F449,  4, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1,  2,   0,  0, "Space Squadron"                      }, // SSQUADRO
  { ARCADIA,         0, 0x83E6E40B,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Star Chess"                          }, // STARCHES
  { ARCADIA,         0, 0x08D8B186,  4, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Super Gobbler"                       }, // SUPERGOB
  { ARCADIA,         0, 0x7666A712,  6, 2, FALSE, TRUE , TRUE , FALSE, FALSE, TRUE,  1,  3,   0,  0, "Space Vultures"                      }, // SVULTURE
  { ARCADIA,         0, 0x0076422E,  4, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Tanks a Lot"                         }, // TANKSALO
  { ARCADIA,         0, 0x8BF2DFA9,  8, 2, FALSE, FALSE, TRUE , FALSE, FALSE, TRUE,  4, 16,   0,  0, "Grand Slam Tennis"                   }, // TENNIS
  { ARCADIA,         0, 0xE66F362D,  4, 2, FALSE, TRUE , TRUE , TRUE , FALSE, TRUE,  1,  2,   0,  0, "The End"                             }, // THE-END
  { ARCADIA,         0, 0x306E39C1,  8, 2, FALSE, FALSE, TRUE , TRUE , FALSE, TRUE,  4, 16,   0,  0, "Turtles/Turpin"                      }, // TURTLES
  { ARCADIA,         0, 0x6289F607, 12, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Dictionary (English + German)"       }, // VIDLEXEG
  { ARCADIA,         0, 0x0739504D, 12, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Dictionary (German + English)"       }, // VIDLEXGE
// known bad dumps (1)
  { ARCADIA,         0, 0x2A3A5C91,  8, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16,   0,  0, "Mobile Soldier Gundam"               }, // GUNDAM-
// homebrews (3)
  { ARCADIA,         0, 0xC1146B0B,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Frogger 1.23"                        }, // FROGGER
  { ARCADIA,         0, 0x63513991,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "JTron 1.14"                          }, // JTRON
  { ARCADIA,         0, 0x296C8465,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Tetris"                              }, // TETRIS
// enhanced versions (8)
  { ARCADIA,         0, 0xC1FB9F3C,  6, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1, 16,   0,  0, "Alien Invaders (enhanced)"           }, // ALIENIN1
  { ARCADIA,         0, 0x5F77087A,  6, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1, 16,   0,  0, "Alien Invaders (enhanced), bkgrnd #2"}, // ALIENIN2
  { ARCADIA,         0, 0x6F68DCD1,  6, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1, 16,   0,  0, "Alien Invaders (enhanced), bkgrnd #3"}, // ALIENIN3
  { ARCADIA,         0, 0x9F915C41,  6, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1, 16,   0,  0, "Alien Invaders (enhanced), bkgrnd #4"}, // ALIENIN4
  { ARCADIA,         0, 0x881E11AC,  6, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Golf (patched)"                      }, // GOLF!
  { ARCADIA,         0, 0x0F34FFBB,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Mobile Soldier Gundam (semi-fixed)"  }, // GUNDAM!
  { ARCADIA,         0, 0xA6E9A90F,  6, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  1,  2,   0,  0, "Space Squadron (enhanced)"           }, // SSQUADR!
  { ARCADIA,         0, 0xB46CACD8,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16,   0,  0, "Star Chess (enhanced)"               }, // STARCHE!
// Interton VC 4000 family (50)
  { INTERTON, MEMMAP_A, 0xA0F5320A,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "4 in a Row"                          }, // 4INAROW  (  I) (variant of CHALLEN-)
  { INTERTON, MEMMAP_A, 0xA8503624,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Air/Sea Attack (suspect dump)"       }, // AIRSEAAT (F  ) (suspect dump) (variant of AIRSEABA)
  { INTERTON, MEMMAP_A, 0xF3D37699,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Air/Sea Battle"                      }, // AIRSEABA (  I) (variant of AIRSEAAT)
  { INTERTON, MEMMAP_C, 0x08CD8135,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Backgammon"                          }, // BACKGAMM (  I)
  { INTERTON, MEMMAP_A, 0xEC2A91B3,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Blackjack"                           }, // BLACKJAC (F+I)
  { INTERTON, MEMMAP_A, 0xA47FE1BF,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Bowling"                             }, // BOWLING  (  I)
  { INTERTON, MEMMAP_B, 0x922C9F0D,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Boxing"                              }, // BOXING   (  I) (variant of PRIZEFI-)
  { INTERTON, MEMMAP_A, 0x619C07C9,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Capture"                             }, // CAPTURE  (F+I)
  { INTERTON, MEMMAP_A, 0x5C7F11E0,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 271, 56, "Car Races"                           }, // CARRACES (  I) (variant of GRNDPRIX)
  { INTERTON, MEMMAP_A, 0x50FD6A18,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 251, 56, "Casino"                              }, // CASINO   (  I)
  { INTERTON, MEMMAP_C, 0xE9C53288,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Chess"                               }, // CHESS1   (  I)
  { INTERTON, MEMMAP_D, 0x1B948AEB,  6, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Chess 2"                             }, // CHESS2   (  I)
  { INTERTON, MEMMAP_A, 0x0AB80F3E,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 75, "Circus"                              }, // CIRCUS   (F+I)
  { INTERTON, MEMMAP_B, 0x11DD7F0D,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Cockpit"                             }, // COCKPIT  (  I)
  { INTERTON, MEMMAP_A, 0x52B8C6E7,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Codebreaker"                         }, // CODEBREA (F  ) (variant of MASTERMI)
  { INTERTON, MEMMAP_A, 0x5E8EE224,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Tank/Plane Battle"                   }, // COMBATA  (F  ) (variant of COMBATB)
  { INTERTON, MEMMAP_A, 0x468E4779,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Tank Battle/Plane Battle"            }, // COMBATB  (  I) (variant of COMBATA)
  { INTERTON, MEMMAP_C, 0x7B868473,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 220, 56, "Draughts"                            }, // DRAUGHTS (  I)
  { INTERTON, MEMMAP_B, 0xD399CE07,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 53, "Golf"                                }, // GOLF     (  I) (variant or overdump of GOLF-)
  { INTERTON, MEMMAP_A, 0x2C770DC3,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 271, 56, "Grand Prix"                          }, // GRNDPRIX (F  ) (variant of CARRACES)
  { INTERTON, MEMMAP_A, 0xFF39521A,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Head On"                             }, // HEADON   (F  )
  { INTERTON, MEMMAP_A, 0xAAEA290F,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Hippodrome"                          }, // HIPPODRO (  I) (variant of HORSERAC)
  { INTERTON, MEMMAP_A, 0x4339E630,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Horse Racing (suspect dump)"         }, // HORSERAC (F  ) (suspect dump) (variant of HIPPODRO)
  { INTERTON, MEMMAP_A, 0x31978AD4,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Hunting"                             }, // HUNTING  (  I) (variant of SHOOTGAL)
  { INTERTON, MEMMAP_A, 0xB3ED1129,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Hyperspace"                          }, // HYPERSPA (  I)
  { INTERTON, MEMMAP_A, 0x6AE47072,  2, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Invaders (Fountain version)"         }, // INVADERA (F  ) (variant of INVADERB)
  { INTERTON, MEMMAP_A, 0x9497204A,  2, 2, FALSE, TRUE , FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Invaders (Interton version)"         }, // INVADERB (  I) (variant of INVADERA)
  { INTERTON, MEMMAP_A, 0x7B2B2B61,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Labyrinth"                           }, // LABYRINT (  I) (variant of SUPERMA-)
  { INTERTON, MEMMAP_A, 0xC44FABB1,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Laser Attack"                        }, // LASERATT (F  )
  { INTERTON, MEMMAP_A, 0x52B8C6E7,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Mastermind"                          }, // MASTERMI (  I) (variant of CODEBREA)
  { INTERTON, MEMMAP_A, 0x66C5975E,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Maths 2"                             }, // MATH2    (F+I)
  { INTERTON, MEMMAP_A, 0xE38E0C03,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Mathematics 1"                       }, // MATHEMA1 (  I) (variant of MATH1-)
  { INTERTON, MEMMAP_B, 0xA640A330,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Metropolis/Hangman"                  }, // METROPOL (  I)
  { INTERTON, MEMMAP_B, 0x27CCE96F,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Monster Man"                         }, // MONSTERM (  I) (variant of SPIDERS-)
  { INTERTON, MEMMAP_B, 0x55011F0A,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Motorcross"                          }, // MOTOCROS (  I)
  { INTERTON, MEMMAP_A, 0xD68DA80A,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Musical Games"                       }, // MUSICALG (F+I)
  { INTERTON, MEMMAP_A, 0x682B876A,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Olympics"                            }, // OLYMPICS (F+I)
  { INTERTON, MEMMAP_A, 0xC6B2CD9A,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Electronic Pinball"                  }, // PINBALLA (F  ) (variant of PINBALLB)
  { INTERTON, MEMMAP_A, 0xADD99C6E,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Pinball"                             }, // PINBALLB (  I) (variant of PINBALLA)
  { INTERTON, MEMMAP_A, 0x2AEB516E,  2, 2, TRUE , FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Planet Defender"                     }, // PLANETDE (F  )
  { INTERTON, MEMMAP_A, 0x9C8E7DE6,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Shooting Gallery"                    }, // SHOOTGAL (F  ) (variant of HUNTING)
  { INTERTON, MEMMAP_A, 0xB589F093,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Shoot Out"                           }, // SHOOTOUT (F+I)
  { INTERTON, MEMMAP_A, 0x87977F92,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Soccer (Fountain version)"           }, // SOCCERA  (F  ) (variant of SOCCERB)
  { INTERTON, MEMMAP_A, 0x05AF8228,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Soccer (Interton version)"           }, // SOCCERB  (  I) (variant of SOCCERA)
  { INTERTON, MEMMAP_A, 0x08209D98,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Solitaire"                           }, // SOLITAIR (  I)
  { INTERTON, MEMMAP_A, 0xB1C31F9A,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Space War"                           }, // SPACEWAR (F+I)
  { INTERTON, MEMMAP_A, 0xA46C2F9E,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Super Invaders"                      }, // SUPERINV (  I)
  { INTERTON, MEMMAP_B, 0x306E37BB,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Super-Space"                         }, // SUPERSPA (  I)
  { INTERTON, MEMMAP_A, 0xEA8F717F,  2, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "Treasure Hunt"                       }, // TREASURE (F+I)
  { INTERTON, MEMMAP_B, 0xBDD652B7,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 63, "Winter Sports"                       }, // WINTERSP (  I)
// known bad dumps (8)
  { INTERTON, MEMMAP_A, 0x8AB96827,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Challenge"                           }, // CHALLEN- (F  ) (variant of 4INAROW)
  { INTERTON, MEMMAP_A, 0x3CF3BAF6,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 53, "Golf"                                }, // GOLF-    (F  ) (variant or underdump of GOLF)
  { INTERTON, MEMMAP_A, 0x2737D62D,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Super Knockout"                      }, // KNOCKOU- (F  )
  { INTERTON, MEMMAP_A, 0x9E3AB142,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Maths 1"                             }, // MATH1-   (F  ) (variant of MATHEMA1)
  { INTERTON, MEMMAP_A, 0x4D37502D,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Mathematics 1"                       }, //   alternate bad dump of of MATHEMA1
  { INTERTON, MEMMAP_A, 0xA931407C,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Prizefight"                          }, // PRIZEFI- (F  ) (variant of BOXING)
  { INTERTON, MEMMAP_A, 0xE5E4C37B,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Spider's Web"                        }, // SPIDERS- (F  ) (variant of MONSTERM)
  { INTERTON, MEMMAP_A, 0x4D3F9CFB,  2, 2, FALSE, FALSE, FALSE, FALSE, TRUE , TRUE,  4, 16, 267, 56, "Super Maze"                          }, // SUPERMA- (F  ) (variant of LABYRINT)
// Elektor TV Games Computer Elektor Software Service (ESS) games (56)
  { ELEKTOR ,        0, 0x45494CBC,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-003-4: 4 in a Row"               },
  { ELEKTOR ,        0, 0x18288A02,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 47, "ESS-003-5: Surround"                 },
  { ELEKTOR ,        0, 0x2DC0DD9E,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-006-2: Code Breaker"             },
  { ELEKTOR ,        0, 0x1D8C1EA5,  7, 8, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-006-3: Rocket Shooting"          },
  { ELEKTOR ,        0, 0x7585F58E,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-1: Mastermind"               },
  { ELEKTOR ,        0, 0x63F7D8FE,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-2: Code Breaker"             },
  { ELEKTOR ,        0, 0x2DB9E572,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-3: Reversi"                  },
  { ELEKTOR ,        0, 0xD4523830,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-4: Amazone"                  },
  { ELEKTOR ,        0, 0xE9403961,  7, 8, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-5: Space Shoot-Out"          },
  { ELEKTOR ,        0, 0xDD59FC15,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-6: 4 in a Row"               },
  { ELEKTOR ,        0, 0xF8D8218B,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-7: 4 in a Row"               },
  { ELEKTOR ,        0, 0x80E543D2,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-007-8: Jackpot"                  },
  { ELEKTOR ,        0, 0xE6262205,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 47, "ESS-007-9: Surround"                 },
  { ELEKTOR ,        0, 0x309A17A5,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-1: Aggressor"                },
  { ELEKTOR ,        0, 0xFC32C62A,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-2: Offshore Fishing"         },
  { ELEKTOR ,        0, 0xE7A63D7F,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-3: Circledrive"              },
  { ELEKTOR ,        0, 0xC782D585,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-4: Seawar"                   },
  { ELEKTOR ,        0, 0x7AE45C16,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-5: Memory"                   },
  { ELEKTOR ,        0, 0x64BEF839,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-6: Labyrinth"                },
  { ELEKTOR ,        0, 0xBD495BED,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-7: Destroyer"                },
  { ELEKTOR ,        0, 0x62B18147,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-8: Starship Enterprise"      },
  { ELEKTOR ,        0, 0x95A254AA,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-9: Blackjack"                },
  { ELEKTOR ,        0, 0x231B2427,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-A: Card Trick"               },
  { ELEKTOR ,        0, 0x90CADC60,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-B: Awari"                    },
  { ELEKTOR ,        0, 0xE9F2688E,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-C: UFO Shooting"             },
  { ELEKTOR ,        0, 0xBDC3DA72,  7, 8, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-D: Raster"                   },
  { ELEKTOR ,        0, 0x83538875,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-E: Nim"                      },
  { ELEKTOR ,        0, 0x21E8568B,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-009-F: Solitaire"                },
  { ELEKTOR ,        0, 0xE02FDA29,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-1: Invaders"                 },
  { ELEKTOR ,        0, 0xC15FF62B,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-2: Pinball"                  },
  { ELEKTOR ,        0, 0x8EDE9085,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-3: Helicopter"               },
  { ELEKTOR ,        0, 0x7EC3B97F,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-4: Hard Nut"                 },
  { ELEKTOR ,        0, 0xF193C235,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  4, 16, 267, 56, "ESS-010-5: Catapult"                 },
  { ELEKTOR ,        0, 0xDBD484BB,  7, 2, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-6: Pilot"                    },
  { ELEKTOR ,        0, 0x2066116A,  7, 2, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-7: Attack from Space"        },
  { ELEKTOR ,        0, 0xC31C0B56,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-8: Reverse"                  },
  { ELEKTOR ,        0, 0xDA58E218,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-9: Rocket Hunting"           },
  { ELEKTOR ,        0, 0x8B66AC75,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 258, 56, "ESS-010-A: Basketball"               },
  { ELEKTOR ,        0, 0xE62573E0,  7, 1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 220, 56, "ESS-010-B: Bursting Balloons"        },
  { ELEKTOR ,        0, 0x49E69462,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-E: Galgenspiel"              },
  { ELEKTOR ,        0, 0x426B44D8,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-010-F: Hangman"                  },
  { ELEKTOR ,        0, 0x994BC0EA,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-1: Snakes and Ladders"       },
  { ELEKTOR ,        0, 0xEC20152C,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-2: Molebasher"               },
  { ELEKTOR ,        0, 0x09EF8D41,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-3: Snap"                     },
  { ELEKTOR ,        0, 0x5206E5CF,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-4: Mazes"                    },
  { ELEKTOR ,        0, 0x597615A6,  7, 8, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, 1,  2, 267, 56, "ESS-011-5: Asteroids"                },
  { ELEKTOR ,        0, 0x015E3686,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-6: Dragster"                 },
  { ELEKTOR ,        0, 0xF5789409,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-7: Omega Landing"            },
  { ELEKTOR ,        0, 0x43E6DB7A,  7, 1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-8: Breakout"                 },
  { ELEKTOR ,        0, 0x743DFF28,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-9: Tiny Tim"                 },
  { ELEKTOR ,        0, 0xD85303AD,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-A: Horse Race + Jackpot"     },
  { ELEKTOR ,        0, 0x77523CC2,  7, 2, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-B: Newton"                   },
  { ELEKTOR ,        0, 0xEBAB31FD,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-C: Horse Races"              },
  { ELEKTOR ,        0, 0xF55DD406,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-D: Painting"                 },
  { ELEKTOR ,        0, 0xED484047,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 4, 16, 267, 56, "ESS-011-E: Submarines + Racing"      },
  { ELEKTOR ,        0, 0x46D5A0EE,  7, 1, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-011-F: Cosmic Adventure"         },
// Elektor TV Games Computer Elektor Software Service (ESS) utilities (14)
  { ELEKTOR ,        0, 0x0D7D868E,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-003-1: Play with the PVI"        },
  { ELEKTOR ,        0, 0x10991986,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-003-2: Clock"                    },
  { ELEKTOR ,        0, 0x51B61371,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 228, 56, "ESS-003-3: Music Box"                },
  { ELEKTOR ,        0, 0x94984EB9,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-003-6: Demonstration Program"    },
  { ELEKTOR ,        0, 0x9CA4965D,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-006-1: Picture Pattern"          },
  { ELEKTOR ,        0, 0x18A53913,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-007-A: Shapes"                   },
  { ELEKTOR ,        0, 0xA7B77712,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 228, 56, "ESS-007-B: Piano"                    },
  { ELEKTOR ,        0, 0xAEFB870B,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-007-C: PVI Progamming"           },
  { ELEKTOR ,        0, 0xF06467B4,  8, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-007-D: Disassembler"             },
  { ELEKTOR ,        0, 0x9CA4965D,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-007-E: Test Patterns"            },
  { ELEKTOR ,        0, 0x5BEE68A3,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-007-F: Lotto"                    },
  { ELEKTOR ,        0, 0xAD39EDC6,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-010-C: Fr Elise"                },
  { ELEKTOR ,        0, 0x755114C2,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-010-D: Editor"                   },
  { ELEKTOR ,        0, 0x902A3B8C,  7, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 267, 56, "ESS-010-1x: Change Words for Hangman"},
// Elektor TV Games Computer Elektor Software Service (ESS) book examples (18)
  { ELEKTOR ,        0, 0x9653ABA1,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Add 2"                               },
  { ELEKTOR ,        0, 0x22180C05,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Add 4"                               },
  { ELEKTOR ,        0, 0x3E1B794C,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Minus 2"                             },
  { ELEKTOR ,        0, 0x1E982CA3,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Minus 4"                             },
  { ELEKTOR ,        0, 0xAAAC97CC,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Explosion"                           },
  { ELEKTOR ,        0, 0xCDAE1CFD,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Gunshot"                             },
  { ELEKTOR ,        0, 0xD5522589,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Joystick"                            },
  { ELEKTOR ,        0, 0x12EFAD0F,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Message"                             },
  { ELEKTOR ,        0, 0xA1553056,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Practice"                            },
  { ELEKTOR ,        0, 0x65B54C14,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Siren"                               },
  { ELEKTOR ,        0, 0x4E917AD2,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Steam Engine"                        },
  { ELEKTOR ,        0, 0xACDC1E77,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Table A"                             },
  { ELEKTOR ,        0, 0x740B53EA,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Table B"                             },
  { ELEKTOR ,        0, 0x686C7949,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Table C"                             },
  { ELEKTOR ,        0, 0xBCDD4049,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Table D"                             },
  { ELEKTOR ,        0, 0xF49B658B,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Table E"                             },
  { ELEKTOR ,        0, 0x06599141,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Wedding March"                       },
  { ELEKTOR ,        0, 0x7DCCBA1A,  4, 2, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 1, 50, 271, 56, "Wolf Whistle"                        }
};

// MODULE ARRAYS----------------------------------------------------------

// This is the (fixed) Elektor monitor ROM ($0..$7FF).
MODULE UBYTE bios[2048] = {
    0x1F,0x00,0x0A,0x1F,0x88,0xB9,0x05,0x94,
    0x05,0xB2,0x76,0x20,0x0C,0x08,0xB9,0xE4,
    0x09,0x3C,0x05,0xCD,0x20,0xCC,0x08,0x9A,
    0x05,0x18,0x6D,0x48,0x78,0x59,0x7B,0x44,
    0x11,0x18,0x15,0x76,0x60,0x20,0x05,0xC0,
    0xCD,0x5F,0x00,0xCD,0x68,0x00,0x59,0x78,
    0x06,0x28,0x3F,0x06,0x02,0x3F,0x01,0x61,
    0x04,0x4B,0xCC,0x08,0xBA,0x04,0x00,0xCC,
    0x08,0xB9,0xCC,0x08,0x9F,0x77,0x02,0x74,
    0x27,0x1B,0x7C,0xB4,0x80,0x16,0x3F,0x01,
    0x81,0x01,0x1E,0x00,0xBD,0x05,0x04,0x0D,
    0x40,0xAD,0xCD,0x7F,0x0A,0x0D,0x60,0xB1,
    0xCD,0x7F,0x1A,0x0D,0x60,0xB5,0xCD,0x7F,
    0x2A,0x0D,0x60,0xB9,0xCD,0x7F,0x4A,0x59,
    0x66,0xB4,0x80,0x18,0x7C,0x04,0x5C,0xF8,
    0x7E,0xC2,0x0D,0x68,0x00,0xCE,0x7F,0x00,
    0x0D,0x68,0x06,0xCE,0x7F,0x10,0x0D,0x68,
    0x0C,0xCE,0x7F,0x20,0x0D,0x28,0x11,0xCE,
    0x3F,0x3F,0xE6,0x06,0x98,0x64,0x04,0xA0,
    0x85,0x12,0xE5,0x8F,0x1A,0x59,0x04,0xFE,
    0xCC,0x1F,0x0D,0xCC,0x1F,0x1D,0xCC,0x1F,
    0x2D,0xCC,0x1F,0x4D,0x17,0x1F,0x1F,0x10,
    0xFF,0x3F,0x3F,0x10,0xFF,0x5F,0x5F,0x10,
    0xFF,0x7F,0x7F,0x10,0xFF,0x0F,0x08,0x9A,
    0x45,0x1F,0x0D,0x61,0x22,0x1A,0x17,0xCC,
    0x08,0xA1,0x3F,0x01,0x6E,0x0E,0x08,0xA0,
    0x60,0xBF,0x01,0x0C,0x04,0x7F,0x4C,0x08,
    0x9F,0xC8,0xFC,0x1F,0x00,0x45,0xF4,0x40,
    0x18,0x1B,0x44,0x1F,0xC8,0xD8,0x05,0xFF,
    0xE3,0x98,0x04,0x09,0x83,0x25,0x7F,0xCD,
    0x08,0x98,0xC3,0x20,0x06,0x09,0xCE,0x48,
    0xA0,0x5A,0x7B,0x1B,0x4D,0xC1,0xCC,0x08,
    0x99,0xE7,0x0D,0x3E,0x01,0x6E,0x01,0x05,
    0x00,0x1F,0x00,0xCD,0x17,0x1F,0x04,0x0C,
    0x1F,0x04,0xA9,0x1F,0x03,0xB0,0x1F,0x00,
    0x23,0x1F,0x05,0x0E,0x1F,0x07,0x58,0x1F,
    0x05,0xE8,0xC0,0x8D,0x84,0x90,0xE0,0x81,
    0x87,0x93,0x00,0x04,0x08,0x0C,0x80,0x80,
    0x8A,0x80,0x01,0x05,0x09,0x0D,0x02,0x06,
    0x0A,0x0E,0x03,0x07,0x0B,0x0F,0xCC,0x08,
    0xAC,0x13,0xCC,0x08,0xB3,0x12,0x76,0x20,
    0xCC,0x08,0xB4,0x75,0x10,0xCD,0x08,0xAD,
    0xCE,0x08,0xAE,0xCF,0x08,0xAF,0x77,0x10,
    0xCD,0x08,0xB0,0xCE,0x08,0xB1,0xCF,0x08,
    0xB2,0x05,0x0A,0x0D,0x41,0x77,0xCD,0x7F,
    0xC0,0x59,0x78,0xCD,0x1E,0x80,0x20,0x06,
    0x50,0xCE,0x5F,0x00,0x5A,0x7B,0x17,0xAA,
    0x09,0x09,0x00,0x00,0x00,0x19,0x00,0xAA,
    0xAA,0x75,0x19,0x20,0xC8,0x93,0xC8,0x9C,
    0x06,0x07,0x05,0x03,0x0E,0x5E,0x88,0x44,
    0xF0,0x98,0x30,0x5A,0x75,0x0C,0x08,0x9D,
    0x0D,0x08,0x9B,0x3F,0x01,0xEE,0xC9,0xF6,
    0x0C,0x08,0x9E,0x0D,0x08,0x9C,0x3B,0xF4,
    0xC9,0xF7,0x09,0xED,0x18,0x08,0x08,0xF4,
    0x18,0x06,0x05,0xFF,0x1B,0x02,0x09,0xEC,
    0x0C,0x08,0x9F,0x3B,0xDF,0xC9,0xFA,0x17,
    0xF9,0x00,0xD0,0x9A,0x7B,0x44,0x7F,0x98,
    0x16,0x02,0xD0,0xD0,0x81,0x64,0x60,0xE6,
    0x03,0x19,0x10,0x09,0x85,0x18,0x02,0x04,
    0xFF,0xCC,0x08,0x9C,0x1F,0x01,0x93,0x04,
    0xFF,0x1B,0x6C,0x09,0x85,0x18,0x02,0x04,
    0xFF,0xCC,0x08,0x9B,0x1B,0xEF,0x59,0x04,
    0x44,0x9F,0xC1,0x17,0xE5,0xFF,0x18,0x03,
    0x60,0x9A,0x04,0x64,0x20,0xC1,0x17,0xF4,
    0x20,0x16,0xF4,0x40,0x98,0x77,0xE1,0x98,
    0x72,0x65,0x80,0x45,0xBF,0x17,0x05,0x08,
    0x75,0x08,0xF5,0x01,0x18,0x08,0x06,0x06,
    0x20,0xCE,0x48,0x78,0x5A,0x7B,0x0D,0x48,
    0x90,0xCD,0x08,0x9B,0x06,0x00,0xF4,0x01,
    0x98,0x0A,0x86,0x02,0xF5,0x01,0x18,0x02,
    0x86,0x01,0x1B,0x06,0xF5,0x01,0x98,0x02,
    0x86,0x01,0x3B,0x0F,0x0D,0x42,0x7B,0xE6,
    0x02,0x1A,0x12,0x44,0x0E,0xE6,0x02,0x18,
    0x16,0x1B,0x10,0x07,0x06,0x44,0xFE,0xC1,
    0xD0,0x81,0x83,0xC1,0x17,0x44,0xE0,0xE6,
    0x00,0x18,0x04,0xD0,0xD0,0xD0,0xD0,0x6F,
    0x48,0x78,0xCF,0x68,0x78,0x5B,0x55,0x0C,
    0x08,0x9B,0x14,0x3B,0x5E,0x0F,0x48,0x78,
    0xCD,0x48,0x78,0x5B,0x78,0x0D,0x08,0x9B,
    0x1F,0x02,0x12,0xE2,0xA6,0xA2,0xA2,0xA2,
    0xE2,0xEE,0x22,0xEE,0x82,0x82,0xEE,0xAE,
    0xA8,0xAE,0xE2,0x22,0x2E,0xEE,0x82,0x82,
    0xE2,0xA2,0xE2,0xEE,0xAA,0xEE,0xA2,0xA2,
    0xEE,0xE8,0xA8,0xEE,0xAA,0xAA,0xAE,0xE2,
    0x82,0x8E,0x8A,0x8A,0xEE,0xEE,0x88,0xEE,
    0x88,0x88,0xE8,0xE8,0x88,0x88,0x88,0xA8,
    0xEE,0xE0,0x40,0x4E,0x4A,0x4A,0xEA,0xE0,
    0xA0,0xEE,0x88,0x88,0x88,0x00,0x00,0x00,
    0xE0,0x00,0xE0,0x40,0x40,0xEE,0x40,0x40,
    0x00,0x00,0x4A,0x04,0x4A,0x00,0x00,0x05,
    0x88,0x0D,0x67,0x90,0xCD,0x67,0x78,0xD9,
    0x78,0x06,0x08,0x04,0x17,0xCE,0x48,0x90,
    0x5A,0x7B,0x17,0xCE,0x08,0x9B,0x3B,0x67,
    0x0A,0xFA,0x07,0x04,0x0E,0x42,0xF5,0xCF,
    0x48,0x90,0x5B,0x78,0x17,0x14,0x0C,0x17,
    0x16,0x0A,0x0D,0x17,0x16,0x15,0x17,0x17,
    0x16,0x0B,0x14,0x01,0x16,0x0B,0x14,0x02,
    0x16,0x0B,0x0E,0x10,0x16,0x0E,0x13,0x0D,
    0x16,0x05,0x0A,0x0D,0x16,0x0F,0x12,0x11,
    0x16,0x12,0x12,0x12,0x12,0x0C,0x08,0xA7,
    0x38,0x1E,0x04,0x01,0xC8,0xF8,0x3B,0x1E,
    0x77,0x0A,0x75,0x01,0xD0,0xD0,0xD0,0xD0,
    0x07,0x04,0xD0,0xD1,0xD2,0xFB,0x7B,0x75,
    0x08,0xCD,0x08,0xA3,0xCE,0x08,0xA2,0x17,
    0x20,0xC8,0xF7,0xC8,0xF8,0x17,0x0C,0x08,
    0xA1,0x09,0xEF,0x0A,0xF0,0x17,0x07,0x08,
    0x3B,0x02,0x02,0xC1,0x3B,0x08,0xCF,0x48,
    0x8F,0x01,0xCF,0x48,0x91,0x17,0x01,0x50,
    0x50,0x50,0x50,0x44,0x0F,0x45,0x0F,0x17,
    0x07,0x08,0x3B,0x5A,0x3B,0x62,0x0C,0x08,
    0xA6,0x14,0xC1,0xF8,0x00,0xC8,0xF8,0x03,
    0xC2,0x04,0x17,0xCE,0x28,0x8F,0xF9,0x7B,
    0x17,0x0C,0x08,0xA3,0x0D,0x08,0xA4,0x0E,
    0x08,0xA5,0xE5,0x08,0x98,0x04,0xE6,0xC0,
    0x1A,0x09,0xCC,0x88,0xA4,0xE5,0x18,0x1A,
    0x02,0xE0,0x17,0xEC,0x88,0xA4,0x17,0x77,
    0x0B,0x05,0x02,0x0D,0x48,0xA4,0x84,0x00,
    0xCD,0x68,0xA4,0x59,0x76,0x75,0x09,0x17,
    0x1A,0x2E,0x01,0x1A,0x03,0x02,0x98,0x1E,
    0x06,0x0C,0x3F,0x02,0xE3,0x04,0x01,0xCC,
    0x08,0xA0,0x0A,0x9E,0xCE,0x08,0x91,0x0E,
    0x68,0xAC,0xC1,0xC8,0x98,0x20,0xCC,0x08,
    0xA7,0x07,0x06,0x1F,0x04,0x80,0x3F,0x03,
    0x1D,0x04,0x17,0xCC,0x08,0x93,0x1B,0x71,
    0xC3,0x0E,0x08,0xA4,0x0C,0x08,0xA3,0xCE,
    0x28,0xAB,0xF7,0x20,0x98,0x12,0xE6,0x09,
    0x1A,0x02,0x06,0x00,0xCA,0xEC,0x04,0x16,
    0xC8,0xE2,0x3F,0x02,0x0E,0x1F,0x03,0xB8,
    0x77,0x0B,0xA6,0x02,0x9A,0x02,0x06,0x08,
    0x75,0x09,0x1B,0x68,0x1A,0x0E,0x01,0x1A,
    0x04,0x02,0x9C,0x04,0x65,0x06,0x08,0x04,
    0x01,0x1F,0x05,0xF7,0x0C,0x08,0xA0,0x99,
    0x1D,0x05,0x02,0x0D,0x48,0xA2,0xCD,0x68,
    0xA4,0x59,0x78,0x3F,0x02,0xD9,0x04,0xFD,
    0xC8,0xB9,0x0C,0x88,0xA4,0xCC,0x08,0xA3,
    0x20,0xCC,0x08,0xA7,0x1B,0x2C,0x3F,0x03,
    0x81,0x98,0x0A,0x0C,0x08,0x99,0xE4,0xC0,
    0x18,0x08,0x3F,0x03,0x9F,0x3F,0x02,0xCF,
    0x1B,0x5C,0x04,0x0A,0x93,0x05,0x02,0x0D,
    0x48,0xA4,0xA4,0x00,0xCD,0x68,0xA4,0x59,
    0x76,0x75,0x09,0x1B,0x68,0x1A,0x1F,0x3F,
    0x03,0x1D,0x0C,0x08,0xA0,0x1D,0x05,0x32,
    0x07,0x04,0x0D,0x08,0xA5,0x0E,0x08,0xA4,
    0x3F,0x03,0x50,0x07,0x08,0x0D,0x08,0xA3,
    0x3F,0x03,0x54,0x1F,0x02,0x0E,0x0C,0x08,
    0xA7,0x98,0x17,0xE6,0xFD,0x18,0x06,0x3F,
    0x02,0xCF,0x3F,0x03,0x9F,0x04,0xFF,0xC8,
    0xD2,0x3B,0x4C,0x3F,0x03,0x81,0x9C,0x04,
    0x15,0x17,0x3B,0x75,0x20,0xC8,0xE0,0x1B,
    0xDB,0x0D,0x08,0x98,0xF5,0x20,0x9C,0x04,
    0xF5,0x60,0x1A,0x27,0x02,0x19,0x1A,0x06,
    0x02,0x0E,0x48,0xB5,0xCE,0x68,0xA2,0x5A,
    0x78,0x06,0x10,0x3F,0x02,0xE3,0x04,0x01,
    0xCC,0x08,0xA0,0x3F,0x03,0x46,0x1F,0x05,
    0x29,0x3F,0x03,0x1D,0x04,0x17,0xCC,0x08,
    0x93,0x1B,0x70,0x06,0x02,0x05,0x16,0xC9,
    0xF6,0xF4,0x20,0xBC,0x03,0x40,0x05,0x02,
    0x0D,0x48,0xA2,0xCE,0x48,0xB5,0x59,0x78,
    0xCD,0x08,0x9A,0x1B,0x56,0x60,0x1A,0x12,
    0x02,0x98,0x56,0x05,0x02,0x0D,0x48,0xB7,
    0xCD,0x68,0xA2,0x59,0x78,0x06,0x14,0x1F,
    0x04,0xC3,0x06,0x04,0x1B,0x4F,0x1A,0x30,
    0x02,0x98,0x1C,0x06,0x04,0x3F,0x02,0xE3,
    0x0D,0x08,0xBF,0x0E,0x08,0xBE,0x04,0x03,
    0xCC,0x08,0xA6,0xCC,0x08,0xA0,0x3F,0x03,
    0x39,0x3F,0x03,0x4E,0x1F,0x02,0x0E,0x3F,
    0x03,0x1D,0x3F,0x03,0x68,0x1B,0xF6,0x9B,
    0x86,0x9B,0x88,0x09,0x03,0x77,0x00,0x1F,
    0x05,0x02,0x0D,0x48,0xA2,0xCD,0x68,0xBE,
    0x0D,0xE8,0xB5,0xCD,0x68,0xA2,0x0D,0xE8,
    0xB7,0xCD,0x68,0xA4,0x0D,0x65,0x37,0xCD,
    0xE8,0xB5,0x0D,0x65,0x39,0xCD,0xE8,0xB7,
    0x59,0x60,0x05,0x05,0x0D,0x45,0x3B,0xCD,
    0x68,0xB9,0x59,0x78,0x0C,0x08,0xB3,0xCC,
    0x08,0xBC,0x75,0x10,0x0D,0x08,0xAD,0x0E,
    0x08,0xAE,0x0F,0x08,0xAF,0x77,0x10,0x0D,
    0x08,0xB0,0x0E,0x08,0xB1,0x0F,0x08,0xB2,
    0x0C,0x08,0xB4,0x92,0x0C,0x08,0xAC,0x75,
    0xFF,0x1F,0x08,0xBB,0x3B,0x37,0x0D,0x08,
    0xB6,0x0E,0x08,0xB5,0xC8,0xF9,0xC8,0xFA,
    0x3B,0x22,0x06,0x10,0x3F,0x02,0xEA,0x04,
    0x15,0xCC,0x08,0x91,0x3F,0x02,0x0E,0x1F,
    0x00,0x38,0x3B,0x19,0x0D,0x08,0xB8,0x0E,
    0x08,0xB7,0xC8,0xF9,0xC8,0xFA,0x3B,0x04,
    0x06,0x14,0x1B,0x60,0xCD,0x08,0xBF,0xCE,
    0x08,0xBE,0x1F,0x03,0x4E,0x3F,0x01,0x3E,
    0x05,0x02,0x0D,0x48,0xA2,0xCD,0xE8,0xB5,
    0x0D,0x68,0xA4,0xCD,0xE8,0xB7,0x59,0x72,
    0x3F,0x02,0xCF,0x20,0xCC,0x08,0x9A,0x17,
    0x1A,0x26,0x01,0x1A,0x06,0x02,0x1D,0x05,
    0x2F,0x1A,0x15,0x04,0x01,0x06,0x18,0xCC,
    0x08,0xA0,0x04,0x03,0xCC,0x08,0xA6,0x3F,
    0x03,0x40,0x3F,0x02,0xE3,0x1F,0x02,0x0E,
    0x0C,0x08,0xA1,0xCC,0x08,0x95,0x1B,0xF6,
    0x02,0x1E,0x06,0x4A,0x06,0x02,0xE4,0x02,
    0x9A,0x0E,0x0E,0x48,0xA2,0xCE,0x68,0xA4,
    0x5A,0x78,0x04,0x02,0x06,0x1C,0x1B,0x4F,
    0x98,0x12,0x77,0x09,0x0E,0x48,0xA2,0x84,
    0x00,0xCE,0x68,0xA8,0x5A,0x76,0x04,0x03,
    0x06,0x20,0x1B,0x6A,0x04,0xFF,0xCC,0x08,
    0xA0,0x20,0xCC,0x08,0xA1,0x06,0x24,0x1F,
    0x06,0x02,0x20,0x07,0x1E,0x3F,0x06,0xF7,
    0xF8,0x79,0x3F,0x06,0xF2,0x07,0x09,0x3F,
    0x06,0xF0,0x20,0xCC,0x08,0xAA,0x04,0x4C,
    0x3B,0xAF,0x08,0xDF,0x3B,0xAB,0x77,0x0B,
    0x0D,0x08,0xA9,0x0C,0x08,0xA8,0xAD,0x08,
    0xA5,0xAC,0x08,0xA4,0x1E,0x05,0xF3,0x19,
    0x08,0x01,0x1C,0x06,0xBB,0xE4,0x10,0x1A,
    0x02,0x04,0x10,0xCC,0x08,0xAB,0x08,0xEA,
    0x3B,0x87,0x08,0xE3,0x3B,0x83,0x08,0xF4,
    0x3F,0x06,0xD0,0x08,0x90,0x3B,0xFA,0x07,
    0x00,0x0F,0xE8,0xA4,0xEB,0xE6,0x18,0x04,
    0x3B,0xEF,0xDB,0x75,0x0C,0x08,0xAA,0x3B,
    0xE8,0x04,0x0A,0x93,0x05,0x02,0x03,0x8D,
    0x48,0xA4,0xCD,0x68,0xA4,0x20,0x59,0x77,
    0x1F,0x06,0x55,0x0C,0x08,0xA2,0x3F,0x06,
    0xD0,0x0C,0x08,0xA3,0x3B,0xF9,0x20,0xCC,
    0x08,0x9A,0x3B,0xF3,0x08,0xD7,0x3B,0xEF,
    0x3F,0x07,0x26,0x77,0x10,0x75,0x08,0x06,
    0x08,0x50,0xD0,0x1A,0x04,0x3B,0x0F,0x1B,
    0x02,0x3B,0x07,0xFA,0x75,0x3B,0x0B,0x75,
    0x19,0x17,0x07,0x06,0x1B,0x02,0x07,0x03,
    0x3B,0x05,0x05,0x32,0xF9,0x7E,0x17,0x05,
    0xFF,0xCD,0x1D,0xFF,0x05,0x08,0xF9,0x7E,
    0xC9,0xF8,0x05,0x07,0xF9,0x7E,0xFB,0x6F,
    0x17,0x77,0x1A,0x06,0x08,0xCE,0x08,0x9B,
    0x3B,0x1F,0xE6,0x86,0x1A,0x05,0xDA,0x78,
    0x1F,0x07,0x88,0x0C,0x08,0x9C,0xD2,0xD0,
    0xC8,0xFA,0x0A,0xEA,0xFA,0x67,0x75,0x18,
    0xC1,0x2C,0x08,0xAA,0xD0,0xC8,0xFB,0x01,
    0x17,0x09,0x8B,0x20,0xCC,0x08,0x98,0x06,
    0x77,0x07,0x03,0xC0,0x01,0x0D,0x1D,0xBF,
    0x21,0x9A,0x04,0xDA,0x74,0xFA,0x72,0xE6,
    0x79,0xFB,0x70,0x15,0x08,0xE7,0xF8,0x64,
    0x0C,0x08,0xA8,0x18,0x5C,0x1F,0x07,0x88,
    0x1A,0x1E,0x0C,0x08,0xA1,0x19,0x05,0x06,
    0x24,0x1F,0x06,0x02,0xCC,0x08,0x95,0x1F,
    0x02,0x0E,0xCE,0x08,0x97,0x3B,0xF9,0x05,
    0x78,0x1F,0x00,0x71,0x3B,0x74,0x1B,0x10,
    0x44,0x20,0xCC,0x08,0xA8,0x05,0x18,0x58,
    0x02,0x05,0x19,0xCD,0x08,0x93,0x3B,0x65,
    0x3F,0x07,0x31,0xE6,0x86,0x1A,0x79,0xE6,
    0x8C,0x19,0x75,0x20,0xCC,0x08,0xAA,0x3F,
    0x07,0x09,0xE4,0x4C,0x98,0x6A,0x0C,0x1F,
    0x15,0x24,0x0A,0xC8,0xFA,0x3B,0xF1,0xC2,
    0x0C,0x08,0xA1,0x18,0x03,0xE2,0x98,0x44,
    0x07,0xFE,0xCF,0x1F,0x4A,0x3B,0x9B,0xCF,
    0x67,0xA6,0xCF,0x67,0xC0,0xDB,0x76,0x3B,
    0x91,0x60,0x98,0x0A,0x06,0x17,0x3F,0x07,
    0x6A,0x05,0xE1,0x1F,0x00,0xBD,0xCC,0x08,
    0xAB,0x3F,0x07,0x09,0x08,0x99,0x98,0x1C,
    0xC3,0x3B,0xF7,0xEB,0xF2,0x18,0x0F,0x0D,
    0x08,0xA8,0x18,0x03,0xCF,0xE8,0xA4,0xEF,
    0xE8,0xA4,0x98,0x08,0xDB,0x6B,0x0C,0x08,
    0xAA,0x1C,0x07,0x88,0x3F,0x05,0xE0,0x06,
    0x08,0x3F,0x05,0x15,0x1F,0x00,0xD4,0x82
};

// MODULE FUNCTIONS-------------------------------------------------------

MODULE UWORD ReadInt(void);
MODULE UBYTE ReadByte(void);
MODULE void WriteInt(UWORD what);
MODULE void WriteByte(UBYTE what);
MODULE void view_pviscreen(void);
MODULE void inputmirrors(int address);
MODULE void a_setmemmap(void);
MODULE void i_setmemmap(void);
MODULE void e_setmemmap(void);
MODULE void fillmem(void);
MODULE void alloc_iobuffer(ULONG thesize);
MODULE void free_iobuffer(void);
MODULE FLAG autosense(void);
MODULE ULONG getcrc32(UBYTE* address);
MODULE void configure(void);

// function pointers
MODULE UBYTE a_cpuread(int address);
MODULE UBYTE i_cpuread(int address);
MODULE UBYTE e_cpuread(int address);
MODULE void a_cpuwrite(int address, UBYTE data);
MODULE void ie_cpuwrite(int address, UBYTE data);

// function pointers
// (these are really variables, so they are defined here instead of aa.h)
EXPORT UBYTE (* cpuread)(int address);
EXPORT void (* cpuwrite)(int address, UBYTE data);

// CODE-------------------------------------------------------------------

EXPORT void change_read(STRPTR thestring)
{   int number;

    /* thestring: contents of the "address" gadget

       This looks at thestring and sets fromnum, tonum, fromstr, tostr,
       tolimit. It is used when the "address" field in the "change"
       requester is modified. */

    if (!stricmp(thestring, "PSU"))
    {   fromnum = (int) psu;
        tolimit = 255;
    } elif (!stricmp(thestring, "PSL"))
    {   fromnum = (int) psl;
        tolimit = 255;
    } elif (!stricmp(thestring, "IAR") || (!stricmp(thestring, "PC")))
    {   fromnum = (int) (page + iar);
        tolimit = 32767;
    } elif
    (   strlen(thestring) == 4
     && !strnicmp(thestring, "RAS", 3)
     && thestring[3] >= '0'
     && thestring[3] <= '7'
    )
    {   fromnum = (int) ras[thestring[3] - '0'];
        tolimit = 32767;
    } elif
    (   strlen(thestring) == 2
     && (thestring[0] == 'R' || thestring[0] == 'r')
     && thestring[1] >= '0'
     && thestring[1] <= '6'
    )
    {   fromnum = (int) r[thestring[1] - '0'];
        tolimit = 255;
    } else
    {   tolimit = 255;

        number = friendly_to_number(thestring);
        if (number < OUTOFRANGE)
        {   fromnum = (int) memory[number];
        } else
        {   fromnum = OUTOFRANGE;
            fromstr[0] = 0;
    }   }

    if (fromnum < OUTOFRANGE)
    {   fromstr[0] = '$';
        stcl_h(&fromstr[1], fromnum);
    }

    tonum = fromnum;
    strcpy(tostr, fromstr);
}

EXPORT void change_write(STRPTR thestring)
{   /* thestring: contents of the "address" gadget

       This looks at thestring and tonum and actually changes the value of
       the register that the user has specified. It is used at the end of
       use of the "change" requester. */

    FLAG found = TRUE;
    int  number;

    if (!stricmp(thestring, "PSU"))
    {   psu = (UBYTE) tonum;
    } elif (!stricmp(thestring, "PSL"))
    {   psl = (UBYTE) tonum;
    } elif (!stricmp(thestring, "IAR") || !stricmp(thestring, "PC"))
    {   page = (UWORD) tonum & PAGE;
        iar =  (UWORD) tonum & ~(PAGE);
    } elif
    (   strlen(thestring) == 4
     && !strnicmp(thestring, "RAS", 3)
     && thestring[3] >= '0'
     && thestring[3] <= '7'
    )
    {   ras[thestring[3] - '0'] = (UWORD) tonum;
    } elif
    (   strlen(thestring) == 2
     && (thestring[0] == 'R' || thestring[0] == 'r')
     && thestring[1] >= '0'
     && thestring[1] <= '6'
    )
    {   r[thestring[1] - '0'] = (UBYTE) tonum;
    } else
    {   found = FALSE;

        number = friendly_to_number(thestring);
        if (number < OUTOFRANGE)
        {   memory[number] = (UBYTE) tonum;
            found = TRUE;
            number_to_friendly(number, thestring, TRUE);
    }   }

    if (found && fromnum != tonum)
    {   strupr(thestring);
        OPENCONSOLE;
        printf("Changed contents of %s from $%lX to $%lX!\n\n", thestring, (ULONG) fromnum, (ULONG) tonum);
        REACTIVATE;
        // this will show, eg. "BGCOLOUR" instead of "BGCOLOUR ($19F9)"
        updatemonitor();
    } /* else
    {   OPENCONSOLE;
        printf("Cancelled!\n\n");
        REACTIVATE;
    } */
}

EXPORT void getfriendly(int number)
{   number_to_friendly(number, friendly, TRUE);
}

EXPORT void number_to_friendly(int number, STRPTR thestring, FLAG both)
{   int i;

/*  number:    input number
    thestring: pointer to output string buffer
    both:      do we want friendly and hex names (TRUE) (eg. "BGCOLOUR
               ($19FD)") or just friendly names (eg. "BGCOLOUR")? */

    if (machine == ARCADIA)
    {   for (i = 0; i < A_EQUIVALENTS; i++)
        {   // OPENCONSOLE;
            // printf("Comparing %s against %s...\n", thestring, a_equivalents[i].text);
            // REACTIVATE;
            if (number == (int) a_equivalents[i].number)
            {   strcpy(thestring, a_equivalents[i].text);
                if (both)
                {   strcat(thestring, " ($");
                    stcl_h(&thestring[strlen(thestring)], number); // integer -> hexstring
                    strcat(thestring, ")");
                }
                return;
    }   }   }
    else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        for (i = 0; i < I_EQUIVALENTS; i++)
        {   // OPENCONSOLE;
            // printf("Comparing %s against %s...\n", thestring, i_equivalents[i].text);
            // REACTIVATE;
            if (number == (int) i_equivalents[i].number)
            {   strcpy(thestring, i_equivalents[i].text);
                if (both)
                {   strcat(thestring, " ($");
                    stcl_h(&thestring[strlen(thestring)], number); // integer -> hexstring
                    strcat(thestring, ")");
                }
                return;
        }   }

        if (machine == ELEKTOR)
        {   for (i = 0; i < E_EQUIVALENTS; i++)
            {   // OPENCONSOLE;
                // printf("Comparing %s against %s...\n", thestring, e_equivalents[i].text);
                // REACTIVATE;
                if (number == (int) e_equivalents[i].number)
                {   strcpy(thestring, e_equivalents[i].text);
                    if (both)
                    {   strcat(thestring, " ($");
                        stcl_h(&thestring[strlen(thestring)], number); // integer -> hexstring
                        strcat(thestring, ")");
                    }
                    return;
    }   }   }   }

    strcpy(thestring, "$");
    stcl_h(&thestring[1], number); // integer -> hexstring
}

EXPORT int friendly_to_number(STRPTR thestring)
{   /* This never returns a negative number. */

    int i,
        number;

    // this assumes the longest friendly string is 13 characters (plus
    // null terminator) (eg. "SPRITECOLLIDE")
    if (strlen(thestring) < 1 || strlen(thestring) > 13)
    {   thestring[0] = 0;
        return(OUTOFRANGE);
    }

    if (machine == ARCADIA)
    {   for (i = 0; i < A_EQUIVALENTS; i++)
        {   // OPENCONSOLE;
            // printf("Comparing %s against %s...\n", thestring, a_equivalents[i].text);
            // REACTIVATE;
            if (!stricmp(thestring, a_equivalents[i].text))
            {   return((int) a_equivalents[i].number);
    }   }   }
    else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        for (i = 0; i < I_EQUIVALENTS; i++)
        {   // OPENCONSOLE;
            // printf("Comparing %s against %s...\n", thestring, i_equivalents[i].text);
            // REACTIVATE;
            if (!stricmp(thestring, i_equivalents[i].text))
            {   return((int) i_equivalents[i].number);
        }   }

        if (machine == ELEKTOR)
        {   for (i = 0; i < E_EQUIVALENTS; i++)
            {   // OPENCONSOLE;
                // printf("Comparing %s against %s...\n", thestring, e_equivalents[i].text);
                // REACTIVATE;
                if (!stricmp(thestring, e_equivalents[i].text))
                {   return((int) e_equivalents[i].number);
    }   }   }   }

    // still no match, must be a numerical address
    if (thestring[0] == '$')
    {   stch_l(&thestring[1], (long *) &number); // hexstring -> integer
    } else
    {   stcd_l(thestring, (long *) &number);     // decstring -> integer
        thestring[0] = '$';
        stcl_h(&thestring[1], number); // integer   -> hexstring
    }

    if (number < 0 || number >= OUTOFRANGE)
    {   thestring[0] = 0;
        return(OUTOFRANGE);
    }

    return(number);
}

EXPORT void project_reset(void)
{   if (!emulating)
    {   return;
    }

    macro_stop();
    cpu_reset();
}

EXPORT void macro_stop(void)
{   if (!emulating)
    {   return;
    }

    if (recmode == RECMODE_PLAY)
    {   free_iobuffer();
    } elif (recmode == RECMODE_RECORD)
    {   // assert(MacroHandle);
        DISCARD fclose(MacroHandle);
        MacroHandle = NULL;
    }

    if (recmode != RECMODE_NORMAL) // avoids useless refreshing
    {   recmode = RECMODE_NORMAL;
        updatesmlgad(GADPOS_MACRO, (ULONG) recmode, TRUE);
        updatemenus();
}   }

EXPORT void macro_restartplayback(void)
{   offset = 0;
    parse_bytes(FALSE); // this sets recmode = RECMODE_PLAY for us
}

EXPORT void arcadia(void)
{   if (machine != ARCADIA)
    {   machine = ARCADIA;
        macro_stop();
        emulating = FALSE;
    }
    fillmem();
    a_setmemmap();
    if (region == REGION_PAL)
    {   region = REGION_NTSC;
    }
    if (sound)
    {   sound_off();
        sound_on();
    }
    if (!flagline)
    {   flagline = TRUE;
    }
    closemonitor();
}

EXPORT void interton(void)
{   if (machine != INTERTON)
    {   memmap = MEMMAP_D; // not that it really matters
        machine = INTERTON;
        macro_stop();
        emulating = FALSE;
    }
    fillmem();
    i_setmemmap();
    if (region == REGION_NTSC)
    {   region = REGION_PAL;
    }
    if (!flagline)
    {   flagline = TRUE;
    }
    if (sound)
    {   sound_off();
        sound_on();
    }
    closemonitor();
}

EXPORT void elektor(void)
{   machine = ELEKTOR;
    emulating = TRUE;
    fillmem(); // must be done before e_setmemmap()!
    e_setmemmap();
    if (region == REGION_NTSC)
    {   region = REGION_PAL;
    }
    if (flagline)
    {   flagline = FALSE;
    }
    if (sound)
    {   sound_off();
        sound_on();
    }
    closemonitor();
}

EXPORT void debug_clearbp(void)
{   // harmless if it's already cleared
    if (bp < OUTOFRANGE)
    {   bp = OUTOFRANGE;
        updatemenu(MENUITEM_CLEARBP);
        OPENCONSOLE;
        printf("Cleared code breakpoint!\n\n");
        REACTIVATE;
}   }
EXPORT void debug_clearwp(void)
{   // harmless if it's already cleared
    if (wp < OUTOFRANGE)
    {   wp = OUTOFRANGE;
        updatemenu(MENUITEM_CLEARWP);
        OPENCONSOLE;
        printf("Cleared data watchpoint!\n\n");
        REACTIVATE;
}   }

EXPORT void pause(void)
{   if (!paused)
    {   paused = TRUE;
        if (sound)
        {   sound_off();
        }
        updatesmlgad(GADPOS_PAUSED, paused, TRUE);
        updatemenu(MENUITEM_PAUSED);
        redrawscreen(); // helpful in frame skipping mode (ensures most
        // recent executed frame is shown, not a frame from a while ago).
}   }

EXPORT void unpause(void)
{   if (paused) // important!
    {   paused = FALSE;
        if (sound)
        {   sound_on();
        }
        updatesmlgad(GADPOS_PAUSED, paused, TRUE);
        updatemenu(MENUITEM_PAUSED);
}   }

EXPORT void cripple(void)
{   crippled = FALSE;
    updatemenus();
    updatebiggads();
    updatesmlgads();
}
EXPORT void uncripple(void)
{   crippled = FALSE;
    updatemenus();
    updatebiggads();
    updatesmlgads();
}

// now is "do you want it done now?" (only for Amiga version)
EXPORT void updatemenu(int which)
{   // assert(MenuPtr);

#ifdef WIN32
    if (!showmenubar)
    {   return; // for speed
    }
#endif

    switch(which)
    {
    case MENUITEM_ANALOG:
        if (analog)                     tick(which);
        else                            untick(which);
    acase MENUITEM_AUTOFIRE:
        if (autofire)                   tick(which);
        else                            untick(which);
    acase MENUITEM_AUTOSAVE:
        if (autosave)                   tick(which);
        else                            untick(which);
    acase MENUITEM_CHANGE:
#ifdef AMIGA
        if (!emulating || fullscreen)   ghost(which);
        else                            unghost(which);
#endif
#ifdef WIN32
        if (!emulating)                 ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_CLEARBP:
        if (bp == OUTOFRANGE)           ghost(which);
        else                            unghost(which);
    acase MENUITEM_CLEARWP:
        if (wp == OUTOFRANGE)           ghost(which);
        else                            unghost(which);
    acase MENUITEM_COLLISIONS:
        if (collisions)                 tick(which);
        else                            untick(which);
#ifdef WIN32
    acase MENUITEM_CONTROLS:
        if (ControlsWindowPtr)          ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_CRAM:
        if (machine != INTERTON || memmap == MEMMAP_A || memmap == MEMMAP_B)
        {                               ghost(which);
        } else                          unghost(which);
    acase MENUITEM_CREATEICONS:
        if (icons)                      tick(which);
        else                            untick(which);
    acase MENUITEM_DEMULTIPLEX:
        if (machine != ARCADIA)         ghost(which);
        else                            unghost(which);
        if (demultiplex)                tick(which);
        else                            untick(which);
    acase MENUITEM_FLAGLINE:
        if (flagline)                   tick(which);
        else                            untick(which);
    acase MENUITEM_FULLSCREEN:
        if (fullscreen)                 tick(which);
        else                            untick(which);
    acase MENUITEM_HELP: // this is the entire Help menu
#ifdef AMIGA
        if (fullscreen)                 ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_JOY1:
        if (joy1)                       tick(which);
        else                            untick(which);
    acase MENUITEM_LIMITREFRESH:
        if (limitrefresh)               tick(which);
        else                            untick(which);
    acase MENUITEM_LOGINSTRUCTIONS:
        if (loginstructions)            tick(which);
        else                            untick(which);
    acase MENUITEM_LOGREADS:
        if (logreads)                   tick(which);
        else                            untick(which);
    acase MENUITEM_LOGWRITES:
        if (logwrites)                  tick(which);
        else                            untick(which);
    acase MENUITEM_LOOP:
        if (loop)                       tick(which);
        else                            untick(which);
    acase MENUITEM_LOWERSCREEN:
        if (machine != ARCADIA)         ghost(which);
        else                            unghost(which);
    acase MENUITEM_MACHINE:
#ifdef AMIGA
        if (crippled)                   ghost(which);
        else                            unghost(which);
        if   (machine == ARCADIA ) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_MACHINE, SN_ARCADIA ))->Flags |= CHECKED;
        elif (machine == INTERTON) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_MACHINE, SN_INTERTON))->Flags |= CHECKED;
        elif (machine == ELEKTOR ) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_MACHINE, SN_ELEKTOR ))->Flags |= CHECKED;
        // else assert(0);
#endif
#ifdef WIN32
        if (crippled)
        {    DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_ARCADIA,  MF_BYCOMMAND | MF_GRAYED );
             DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_INTERTON, MF_BYCOMMAND | MF_GRAYED );
             DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_ELEKTOR,  MF_BYCOMMAND | MF_GRAYED );
        } else
        {    DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_ARCADIA,  MF_BYCOMMAND | MF_ENABLED);
             DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_INTERTON, MF_BYCOMMAND | MF_ENABLED);
             DISCARD EnableMenuItem(MenuPtr, ID_MACHINE_ELEKTOR,  MF_BYCOMMAND | MF_ENABLED);
        }
        if   (machine == ARCADIA ) DISCARD CheckMenuRadioItem(MenuPtr, ID_MACHINE_ARCADIA, ID_MACHINE_ELEKTOR, ID_MACHINE_ARCADIA , MF_BYCOMMAND);
        elif (machine == INTERTON) DISCARD CheckMenuRadioItem(MenuPtr, ID_MACHINE_ARCADIA, ID_MACHINE_ELEKTOR, ID_MACHINE_INTERTON, MF_BYCOMMAND);
        elif (machine == ELEKTOR ) DISCARD CheckMenuRadioItem(MenuPtr, ID_MACHINE_ARCADIA, ID_MACHINE_ELEKTOR, ID_MACHINE_ELEKTOR , MF_BYCOMMAND);
        // else assert(0);
#endif
    acase MENUITEM_MACRO:

#ifdef AMIGA
        if (!emulating || crippled)
        {   DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STARTRECORDING,  NOSUB));
            DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_RESTARTPLAYBACK, NOSUB));
            DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STOP,            NOSUB));
        } elif (recmode == RECMODE_PLAY)
        {   DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STARTRECORDING,  NOSUB));
            DISCARD  OnMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_RESTARTPLAYBACK, NOSUB));
            DISCARD  OnMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STOP,            NOSUB));
        } elif (recmode == RECMODE_RECORD)
        {   DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STARTRECORDING,  NOSUB));
            DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_RESTARTPLAYBACK, NOSUB));
            DISCARD  OnMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STOP,            NOSUB));
        } elif (recmode == RECMODE_NORMAL)
        {   DISCARD  OnMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STARTRECORDING,  NOSUB));
            DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_RESTARTPLAYBACK, NOSUB));
            DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_MACRO, IN_STOP,            NOSUB));
        } // else assert(0);
#endif
#ifdef WIN32
        if (!emulating || crippled)
        {   DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STARTRECORDING,  MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_RESTARTPLAYBACK, MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STOP,            MF_BYCOMMAND | MF_GRAYED );
        } elif (recmode == RECMODE_PLAY)
        {   DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STARTRECORDING,  MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_RESTARTPLAYBACK, MF_BYCOMMAND | MF_ENABLED);
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STOP,            MF_BYCOMMAND | MF_ENABLED);
        } elif (recmode == RECMODE_RECORD)
        {   DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STARTRECORDING,  MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_RESTARTPLAYBACK, MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STOP,            MF_BYCOMMAND | MF_ENABLED);
        } elif (recmode == RECMODE_NORMAL)
        {   DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STARTRECORDING,  MF_BYCOMMAND | MF_ENABLED);
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_RESTARTPLAYBACK, MF_BYCOMMAND | MF_GRAYED );
            DISCARD EnableMenuItem(MenuPtr, ID_MACRO_STOP,            MF_BYCOMMAND | MF_GRAYED );
        } // else assert(0);
#endif
    acase MENUITEM_MONITOR:
#ifdef WIN32
        if (MonitorWindowPtr)           ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_NARROW:
        if (fullscreen)                 ghost(which);
        else                            unghost(which);
        if   (wide == 1)                tick(which);
        elif (wide == 2)                untick(which);
        // else assert(0);
    acase MENUITEM_OPEN:
        if (crippled)                   ghost(which);
        else                            unghost(which);
    acase MENUITEM_PAUSED:
        if (paused)                     tick(which);
        else                            untick(which);
    acase MENUITEM_POINTER:
        if (showpointer)                tick(which);
        else                            untick(which);
    acase MENUITEM_PSGS:
        if (machine != ELEKTOR)         ghost(which);
        else                            unghost(which);
    acase MENUITEM_REGION:
#ifdef AMIGA
        if   (region == REGION_NTSC) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_SPEED, SN_NTSC))->Flags |= CHECKED;
        elif (region == REGION_PAL ) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_SPEED, SN_PAL ))->Flags |= CHECKED;
        // else assert(0);
#endif
#ifdef WIN32
        if   (region == REGION_NTSC) DISCARD CheckMenuRadioItem(MenuPtr, ID_OPTIONS_SPEED_NTSC, ID_OPTIONS_SPEED_PAL, ID_OPTIONS_SPEED_NTSC, MF_BYCOMMAND);
        elif (region == REGION_PAL ) DISCARD CheckMenuRadioItem(MenuPtr, ID_OPTIONS_SPEED_NTSC, ID_OPTIONS_SPEED_PAL, ID_OPTIONS_SPEED_PAL , MF_BYCOMMAND);
        // else assert(0);
#endif
    acase MENUITEM_RESET:
        if (!emulating || crippled)     ghost(which);
        else                            unghost(which);
    acase MENUITEM_RESETTOMONITOR:
        if (!emulating || crippled || machine != ELEKTOR) // actually it would be safe when crippled
        {                               ghost(which);
        } else                          unghost(which);
    acase MENUITEM_RUNTODMA:
        if (!emulating || machine != ARCADIA)
                                        ghost(which);
        else                            unghost(which);
    acase MENUITEM_RUNTOFRAME:
        if (!emulating)                 ghost(which);
        else                            unghost(which);
    acase MENUITEM_RUNTORASTLINE:
        if (!emulating)                 ghost(which);
        else                            unghost(which);
    acase MENUITEM_RUNTORASTN:
        if (!emulating)                 ghost(which);
        else                            unghost(which);
    acase MENUITEM_SAVESNP:
        if (!emulating || crippled)     ghost(which);
        else                            unghost(which);
    acase MENUITEM_SAVEROM:
        if (!emulating)                 ghost(which);
        else                            unghost(which);
    acase MENUITEM_SAVETVC:
        if (machine != ELEKTOR)         ghost(which);
        else
        {                            // assert(emulating);
                                        unghost(which);
        }
    acase MENUITEM_SENSEGAME:
#ifdef AMIGA
        // other sizes are automatically cleared
        if   (sensegame == SENSEGAME_VERBOSE) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_SENSEGAME, SN_VERBOSE))->Flags |= CHECKED;
        elif (sensegame == SENSEGAME_QUIET  ) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_SENSEGAME, SN_QUIET  ))->Flags |= CHECKED;
        elif (sensegame == SENSEGAME_NO     ) ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_SENSEGAME, SN_NO     ))->Flags |= CHECKED;
#endif
#ifdef WIN32
        if   (sensegame == SENSEGAME_VERBOSE) CheckMenuRadioItem(MenuPtr, ID_SENSEGAME_VERBOSE, ID_SENSEGAME_NO, ID_SENSEGAME_VERBOSE, MF_BYCOMMAND);
        elif (sensegame == SENSEGAME_QUIET  ) CheckMenuRadioItem(MenuPtr, ID_SENSEGAME_VERBOSE, ID_SENSEGAME_NO, ID_SENSEGAME_QUIET  , MF_BYCOMMAND);
        elif (sensegame == SENSEGAME_NO     ) CheckMenuRadioItem(MenuPtr, ID_SENSEGAME_VERBOSE, ID_SENSEGAME_NO, ID_SENSEGAME_NO     , MF_BYCOMMAND);
        // else assert(0);
#endif
	acase MENUITEM_SETBP:
#ifdef AMIGA
        if (fullscreen)                 ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_SETWP:
#ifdef AMIGA
        if (fullscreen)                 ghost(which);
        else                            unghost(which);
#endif
    acase MENUITEM_SIZE:
#ifdef AMIGA
        if (fullscreen)
        {                     DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_1XSIZE));
                              DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_2XSIZE));
                              DISCARD OffMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_3XSIZE));
        } else
        {                      DISCARD OnMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_1XSIZE));
                               DISCARD OnMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_2XSIZE));
                               DISCARD OnMenu(MainWindowPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_3XSIZE));
        }
        // other sizes are automatically cleared
        if   (size == 1)                ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_1XSIZE))->Flags |= CHECKED;
        elif (size == 2)                ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_2XSIZE))->Flags |= CHECKED;
        elif (size == 3)                ItemAddress(MenuPtr, FULLMENUNUM(MN_SETTINGS, IN_GRAPHICS, SN_3XSIZE))->Flags |= CHECKED;
#endif
#ifdef WIN32
        if (fullscreen)
        {                       DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_1XSIZE,  MF_BYCOMMAND | MF_GRAYED);
                                DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_2XSIZE,  MF_BYCOMMAND | MF_GRAYED);
                                DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_3XSIZE,  MF_BYCOMMAND | MF_GRAYED);
        } else
        {                       DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_1XSIZE,  MF_BYCOMMAND | MF_ENABLED);
                                DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_2XSIZE,  MF_BYCOMMAND | MF_ENABLED);
                                DISCARD EnableMenuItem(MenuPtr, ID_OPTIONS_GRAPHICS_3XSIZE,  MF_BYCOMMAND | MF_ENABLED);
        }
        if   (size == 1)    DISCARD CheckMenuRadioItem(MenuPtr, ID_OPTIONS_GRAPHICS_1XSIZE, ID_OPTIONS_GRAPHICS_3XSIZE, ID_OPTIONS_GRAPHICS_1XSIZE, MF_BYCOMMAND);
        elif (size == 2)    DISCARD CheckMenuRadioItem(MenuPtr, ID_OPTIONS_GRAPHICS_1XSIZE, ID_OPTIONS_GRAPHICS_3XSIZE, ID_OPTIONS_GRAPHICS_2XSIZE, MF_BYCOMMAND);
        elif (size == 3)    DISCARD CheckMenuRadioItem(MenuPtr, ID_OPTIONS_GRAPHICS_1XSIZE, ID_OPTIONS_GRAPHICS_3XSIZE, ID_OPTIONS_GRAPHICS_3XSIZE, MF_BYCOMMAND);
        // else assert(0);
#endif
    acase MENUITEM_SOUND:
        if (sound)                      tick(which);
        else                            untick(which);
    acase MENUITEM_STEP:
        if (!emulating)                 ghost(which);
        else                            unghost(which);
    acase MENUITEM_STRETCH:
        if (!fullscreen)                ghost(which);
        else                            unghost(which);
        if (stretch)                    tick(which);
        else                            untick(which);
    acase MENUITEM_SWAPPED:
        if (swapped)                    tick(which);
        else                            untick(which);
    acase MENUITEM_TITLEBAR:
        // it's always enabled on IBM-PC version
#ifdef AMIGA
        if (!fullscreen)                ghost(which);
        else                            unghost(which);
#endif
        if (showtitlebar)               tick(which);
        else                            untick(which);
    acase MENUITEM_TOOLBAR:
#ifdef WIN32
        if (showtoolbar)                tick(which);
        else                            untick(which);
#endif
    acase MENUITEM_TRACECPU:
        if (trace)                      tick(which);
        else                            untick(which);
    acase MENUITEM_USEHACKS:
        if (machine == ARCADIA || sensegame == SENSEGAME_NO)
        {                               ghost(which);
        } else                          unghost(which);
		if (usehacks)                   tick(which);
        else                            untick(which);
    acase MENUITEM_VLOCK:
        if (machine != ARCADIA)         ghost(which);
        else                            unghost(which);
        if (vlock)                      tick(which);
        else                            untick(which);
    acase MENUITEM_WARP:
        if (warp)                       tick(which);
        else                            untick(which);
    acase MENUITEM_WATCHREADS:
        if (watchreads)                 tick(which);
        else                            untick(which);
    adefault:
    break;
}   }

EXPORT void updatesmlgad(int which, ULONG state, FLAG now)
{
#ifdef AMIGA
    if (fullscreen)
    {   return; // for safety
    }

    if (now)
    {   detachsmlgads();
    }
#endif
#ifdef WIN32
    if (!showtoolbar)
    {   return; // for speed
    }
#endif

    switch(which)
    {
    case GADPOS_FLAGLINE:
    case GADPOS_AUTOFIRE:
    case GADPOS_ANALOG:
    case GADPOS_JOY1:
    case GADPOS_SWAPPED:
    case GADPOS_PAUSED:
    case GADPOS_COLLISIONS:
    case GADPOS_SOUND:
    case GADPOS_WARP:
        setbutton(which, TRUE, (FLAG) state);
    break;
    case GADPOS_VLOCK:
    case GADPOS_DEMULTIPLEX:
        if (machine == ARCADIA)
        {   setbutton(which, TRUE, (FLAG) state);
        } else
        {   // assert(machine == INTERTON || machine == ELEKTOR);
            setbutton(which, FALSE, (FLAG) state);
        }
    break;
    case GADPOS_REGION:
        if (state == REGION_PAL)
        {   setbutton(which, TRUE, (FLAG) TRUE);
        } else
        {   // assert(state == REGION_NTSC);
            setbutton(which, TRUE, (FLAG) FALSE);
        }
    break;
    case GADPOS_MACRO:
#ifdef AMIGA
        DISCARD SetGadgetAttrs
        (   gadgets[GID_BU1], MainWindowPtr, NULL,
            GA_Image,    smallimage[recmode],
            GA_Disabled, (!emulating || crippled),
        TAG_DONE);
        // this autorefreshes
#endif
#ifdef WIN32
        if (!emulating || crippled)
        {   SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLEPLAYING,   0);
            SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLERECORDING, 0);
        } elif (recmode == RECMODE_PLAY)
        {   SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLEPLAYING,   TBSTATE_ENABLED | TBSTATE_CHECKED);
            SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLERECORDING, 0);
        } elif (recmode == RECMODE_RECORD)
        {   SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLEPLAYING,   0);
            SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLERECORDING, TBSTATE_ENABLED | TBSTATE_CHECKED);
        } else
        {   // assert(recmode == RECMODE_NORMAL);
            SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLEPLAYING,   0);
            SendMessage(hToolbar, TB_SETSTATE, ID_MACRO_TOGGLERECORDING, TBSTATE_ENABLED);
        }
#endif
    break;
    default:
    break;
    }

#ifdef AMIGA
    if (now)
    {   attachsmlgads();
    }
#endif
}

EXPORT void updatesmlgads(void)
{
#ifdef AMIGA
    if (fullscreen)
    {   return;
    }

    detachsmlgads();
#endif

    // graphics
    updatesmlgad(GADPOS_FLAGLINE   , flagline   , FALSE);
    updatesmlgad(GADPOS_VLOCK      , vlock      , FALSE);
    // controllers
    updatesmlgad(GADPOS_AUTOFIRE   , autofire   , FALSE);
    updatesmlgad(GADPOS_ANALOG     , analog     , FALSE);
    updatesmlgad(GADPOS_JOY1       , joy1       , FALSE);
    updatesmlgad(GADPOS_SWAPPED    , swapped    , FALSE);
    // speed
    updatesmlgad(GADPOS_PAUSED     , paused     , FALSE);
    updatesmlgad(GADPOS_WARP       , warp       , FALSE);
    updatesmlgad(GADPOS_REGION     , region     , FALSE);
    // sprites
    updatesmlgad(GADPOS_COLLISIONS , collisions , FALSE);
    updatesmlgad(GADPOS_DEMULTIPLEX, demultiplex, FALSE);
    // misc
    updatesmlgad(GADPOS_SOUND      , sound      , FALSE);

#ifdef AMIGA
    attachsmlgads();
#endif

    updatesmlgad(GADPOS_MACRO      , (ULONG) recmode, TRUE );
}

EXPORT void updatemenus(void)
{   int i;

    for (i = 0; i < MENUITEMS; i++)
    {   updatemenu(i);
}   }

MODULE void alloc_iobuffer(ULONG thesize)
{   // If, for example, we were playing an EAR and then a BIN was dragged
    // over, we will need to free the old IOBuffer
    if (IOBuffer)
    {   free_iobuffer();
    }
    IOBuffer = (UBYTE *) malloc(thesize);
}
MODULE void free_iobuffer(void)
{   // assert(IOBuffer);
    free(IOBuffer);
    IOBuffer = NULL;
}

MODULE void a_setmemmap(void)
{   int address;

    cpuread  = a_cpuread;
    cpuwrite = a_cpuwrite;

    for (address = 0; address < 32 * KILOBYTE; address++)
    {   memflags[address] = 0;
        mirror_r[address] =
        mirror_w[address] = address;

        if
        (    address <= 0x0FFF                       // ROM
    // not occurring:    $1000..$17FF                   mirror
    // legal:            $1800..$18CF                   upper screen
    // legal:            $18D0..$18EF                   user RAM
    // legal:            $18F0..$18F7                   R/W hardware registers
    // legal:            $18F8..$18FB                   user RAM
    // legal:            $18FC                          R/W hardware register
    // legal:            $18FD                          -/W hardware register
    // legal:            $18FE                          R/W hardware register
         || (address >= 0x18FF && address <= 0x197F) // CHARLINE, PnXKEYS/PALLADIUM, CONSOLE, unmapped
    // legal:            $1980..$19BF                   R/W hardware registers
         || (address >= 0x19C0 && address <= 0x19F7) // unmapped
    // legal:            $19F8..$19FB                   -/W hardware registers
         || (address >= 0x19FC && address <= 0x19FF) // BGCOLLIDE, SPRITECOLLIDE, PnPADDLE
    // legal:            $1A00..$1ACF                   lower screen
    // legal:            $1AD0..$1AFF                   user RAM
         ||  address >= 0x1B00                       // not occurring, ROM
        )
        {   memflags[address] |= NOWRITE;
        }

        if
        (
        // legal:                $0000              ..$0FFF     ROM
        // not occurring:        $1000              ..$17FF     mirrored
        // legal:                $1800              ..$18CF     upper screen
        // legal:                $18D0              ..$18EF     user RAM
        // legal:                $18F0              ..$18F7     R/W hardware regs
        // legal:                $18F8              ..$18FB     user RAM
        // legal:                $18FC              ..$18FE     R/W hardware regs
        // legal:                $18FF              ..$1908     R/- hardware regs
                    (address >= 0x1909 && address <= 0x197F) // unmapped (apparently reads as $40 or $C0)
        // legal:                $1980              ..$19BF     R/W hardware regs
                 || (address >= 0x19C0 && address <= 0x19FB) // unmapped (apparently reads as $FF), -/W hardware regs
        // legal:                $19FC              ..$19FF     read-once hardware regs
        // legal:                $1A00              ..$1ACF     lower screen
        // legal:                $1AD0              ..$1AFF     user RAM
        // not occurring:        $1B00              ..$1FFF     mirrored
        // legal:                $2000              ..$2FFF     ROM
        // not occurring:        $3000              ..$3FFF     mirrored
        // legal:                $4000              ..$4FFF     ROM
        // not occurring:        $5000              ..$5FFF     mirrored
        // legal:                $6000              ..$6FFF     ROM
        // not occurring:        $7000              ..$7FFF     mirrored
        )
        {   memflags[address] |= NOREAD;
        }

        if (address >= 0x19FC && address <= 0x19FF) // read-once: $19FC..$19FF: PnPADDLE, SPRITECOLLIDE, BGCOLLIDE
        {   memflags[address] |= READONCE;
        }

        if (address == A_PITCH || address == A_VOLUME)
        {   memflags[address] |= AUDIBLE;
        }

        if ((address & 0x1000) && (address <= 0x17FF || address >= 0x1B00))
        // $1000..$17FF
        // $1B00..$1FFF
        // $3000..$3FFF
        // $5000..$5FFF
        // $7000..$7FFF
        {   memflags[address] |= MIRRORED_R | MIRRORED_W;

            // primary mirroring
            mirror_r[address] &= 0x13FF; // -> $1000..$13FF (mask of $0001 0011 1111 1111)
            mirror_r[address] |= 0x0800; // -> $1800..$1BFF (set  of $0000 1000 0000 0000)

            // secondary mirroring
            if (mirror_r[address] >= 0x1B00 && mirror_r[address] <= 0x1BFF)
            {   mirror_r[address] -=  0x200; // $1B00..$1BFF -> $1900..$19FF
            }

            mirror_w[address] = mirror_r[address];
}   }   }

MODULE void i_setmemmap(void)
{   int address;

    cpuread  = i_cpuread;
    cpuwrite = ie_cpuwrite;

    // only MIRRORED_R and/or MIRRORED_W need be set for mirrored regions.

    for (address = 0; address < 32 * KILOBYTE; address++)
    {   memflags[address] = 0;
        mirror_r[address] =
        mirror_w[address] = address;

        // this is only responsible for $0000..$15FF and $1800..$1DFF
        // regions
        switch(memmap)
        {
        case MEMMAP_A: // 2K ROM + 0K RAM
            if
            (    address <= 0x15FF
             || (address >= 0x1800 && address <= 0x1DFF)
            )
            {   memflags[address] |= NOWRITE;
            }
            if
            (   (address >=  0x800 && address <= 0x15FF)
             || (address >= 0x1800 && address <= 0x1DFF)
            )
            {   memflags[address] |= NOREAD;
            }
            // $0000..$07FF: ROM
            // $0800..$15FF: unused
            // $1600..$17FF: mirror of $1E00..$1FFF, as usual
        acase MEMMAP_B: // 4K ROM + 0K RAM
            if
            (    address <= 0x15FF
             || (address >= 0x1800 && address <= 0x1DFF)
            )
            {   memflags[address] |= NOWRITE;
            }
            if
            (   (address >= 0x1000 && address <= 0x15FF)
             || (address >= 0x1800 && address <= 0x1DFF)
            )
            {   memflags[address] |= NOREAD;
            }
            // $0000..$0FFF: ROM
            // $1000..$15FF: unused
            // $1600..$17FF: mirror of $1E00..$1FFF, as usual
        acase MEMMAP_C: // 4K ROM + 1K RAM
            if (address <= 0x0FFF)
            {   memflags[address] |= NOWRITE;
            }
            // we are allowed to read everything (ROM, cartridge RAM,
            // mirror of noise/input/PVI, mirror of cartridge RAM)
            // $0000..$0FFF: ROM
            // $1000..$15FF: cartridge RAM, and mirror of cartridge RAM
            // $1600..$17FF: mirror of $1E00..$1FFF, as usual
            // $1800..$1DFF: mirror of cartridge RAM
        acase MEMMAP_D: // 6K ROM + 1K RAM
            if (address <= 0x15FF)
            {   memflags[address] |= NOWRITE; // $0000..$15FF: 5.5K of ROM
            }
            // we are allowed to read everything (ROM, cartridge RAM,
            // mirror of noise/input/PVI, mirror of cartridge RAM)
            // $0000..$15FF: ROM
            // $1600..$17FF: mirror of $1E00..$1FFF, as usual
            // $1800..$1DFF: cartridge RAM, and mirror of cartridge RAM
        adefault:
            // assert(0);
        break;
        }

        if
        (
            (address >= 0x1E00 && address <= 0x1E7F) // unmapped
        // legal:        $1E80                          hardware register
         || (address >= 0x1E81 && address <= 0x1EFF) // unknown, R/- hardware registers, unknown
        // legal:        $1F00..$1F2D                   hardware registers, RAM, h/w regs, RAM, h/w regs
         || (address >= 0x1F2E && address <= 0x1F3F) // unmapped
        // legal:        $1F40..$1F6D                   hardware registers, RAM
         || (address >= 0x1F6E && address <= 0x1F7F) // unmapped
        // legal:        $1F80..$1FAD                   grid, RAM
         || (address >= 0x1FAE && address <= 0x1FBF) // unmapped
        // legal:        $1FC0..$1FC3                   hardware registers
         || (address >= 0x1FC4 && address <= 0x1FC5) // unused
        // legal:        $1FC6..$1FC9                   hardware registers
         ||  address >= 0x1FCA                       // R/- hardware registers, unused, mirrors (not occurring), semi-mirrors
        )
        {   memflags[address] |= NOWRITE;
        }

        if
        (   (address >= 0x1E00 && address <= 0x1E7F) // unmapped
    // legal:            $1E80                          hardware register
         || (address >= 0x1E81 && address <= 0x1E87) // unknown
    // legal:            $1E88              ..$1E8E     R/- hardware registers
         || (address >= 0x1E8F && address <= 0x1EFF) // unknown
    // legal:            $1F00              ..$1F2D     hardware registers, RAM, h/w regs, RAM, h/w regs
         || (address >= 0x1F2E && address <= 0x1F3F) // unmapped
    // legal:            $1F40              ..$1F6D     hardware registers, RAM
         || (address >= 0x1F6E && address <= 0x1F7F) // unmapped
    // legal:            $1F80              ..$1FAD     grid, RAM
         || (address >= 0x1FAE && address <= 0x1FC9) // unmapped, -/W (write-only) and -/- (unusable) hardware registers
    // legal:            $1FCA              ..$1FCD     R/- (read-only) hardware registers
         || (address >= 0x1FCE && address <= 0x1FD9) // unused, mirrors (not occurring)
    // legal:            $1FDA              ..$1FDB     semi-mirrors
         || (address >= 0x1FDC && address <= 0x1FE9) // mirrors (not occurring)
    // legal:            $1FEA              ..$1FEB     semi-mirrors
         || (address >= 0x1FEC && address <= 0x1FF9) // mirrors (not occurring)
    // legal:            $1FFA              ..$1FFB     semi-mirrors
         ||  address >= 0x1FFC                       // mirrors (not occurring)
        )
        {   memflags[address] |= NOREAD;
        }

        if
		(	(address >= 0x1FCA && address <= 0x1FCB)
         || (address >= 0x1FDA && address <= 0x1FDB)
         || (address >= 0x1FEA && address <= 0x1FEB)
         || (address >= 0x1FFA && address <= 0x1FFB)
        )
		{   memflags[address] |= READONCE;
        }
        if (address == I_PITCH || address == I_NOISE)
        {   memflags[address] |= AUDIBLE;
        }

        /* An address such as $77FF will be a 3-level mirror!
        $77FF -> $17FF after primary   mirroring
        $17FF -> $1FFF after secondary mirroring
        $1FFF -> $1FCF after tertiary  mirroring */

        // primary write mirroring
        if (mirror_r[address] >= 0x2000) // could use address instead of memmap[address]
        // $2000..$3FFF: mirror of $0000..$1FFF
        // $4000..$5FFF: mirror of $0000..$1FFF
        // $6000..$7FFF: mirror of $0000..$1FFF
        {   memflags[address] |= MIRRORED_R;
            mirror_r[address] &= 0x1FFF;
        }
        // secondary read mirroring
        if (mirror_r[address] >= 0x1600 && mirror_r[address] <= 0x17FF) // mirror of $1E00..$1FFF
        {   memflags[address] |= MIRRORED_R;
            mirror_r[address] += 0x800;
        }
        // tertiary read mirroring
        // mirrors of $1C00..$1C09 and $1C0C..$1C0F.
        // $1C0A..$1C0B are semi-mirrored.
        if
        (   (mirror_r[address] >= 0x1FD0 && mirror_r[address] <= 0x1FD9)
         || (mirror_r[address] >= 0x1FDC && mirror_r[address] <= 0x1FE9)
         || (mirror_r[address] >= 0x1FEC && mirror_r[address] <= 0x1FF9)
         || (mirror_r[address] >= 0x1FFC && mirror_r[address] <= 0x1FFE) // $1FFF is a randomizer
        )
        {   memflags[address] |= MIRRORED_R;
            mirror_r[address] &= 0xFFCF; // apply mask of %1111111111001111
        }

        // primary write mirroring
        if (mirror_w[address] >= 0x2000) // could use address instead of memmap[address]
        // $2000..$3FFF: mirror of $0000..$1FFF
        // $4000..$5FFF: mirror of $0000..$1FFF
        // $6000..$7FFF: mirror of $0000..$1FFF
        {   memflags[address] |= MIRRORED_W;
            mirror_w[address] &= 0x1FFF;
        }
        // secondary write mirroring
        if (mirror_w[address] >= 0x1600 && mirror_w[address] <= 0x17FF) // mirror of $1E00..$1FFF
        {   memflags[address] |= MIRRORED_W;
            mirror_w[address] += 0x800;
        }
        // tertiary write mirroring
        // mirrors of $1C00..$1C09 and $1C0C..$1C0F.
        // $1C0A..$1C0B are semi-mirrored.
        if
        (   (mirror_r[address] >= 0x1FD0 && mirror_r[address] <= 0x1FD9)
         || (mirror_r[address] >= 0x1FDC && mirror_r[address] <= 0x1FE9)
         || (mirror_r[address] >= 0x1FEC && mirror_r[address] <= 0x1FF9)
         || (mirror_r[address] >= 0x1FFC && mirror_r[address] <= 0x1FFE) // $1FFF is a randomizer
        )
        {   memflags[address] |= MIRRORED_W;
            mirror_r[address] &= 0xFFCF; // apply mask of %1111111111001111
        }

        inputmirrors(address);

        if (memmap == MEMMAP_C)
        {   if (mirror_r[address] >= 0x1400 && mirror_r[address] <= 0x15FF) // mirror of $1000..$11FF
            {   memflags[address] |= MIRRORED_R;
                mirror_r[address] -= 0x400;
            } elif (mirror_r[address] >= 0x1800 && mirror_r[address] <= 0x1BFF) // mirror of $1000..$13FF
            {   memflags[address] |= MIRRORED_R;
                mirror_r[address] -= 0x800;
            } elif (mirror_r[address] >= 0x1C00 && mirror_r[address] <= 0x1DFF) // mirror of $1400..$15FF (which is itself a mirror of $1000..$11FF)
            {   memflags[address] |= MIRRORED_R;
                mirror_r[address] -= 0xC00; // 2-level mirror, resolved completely here
            }

            if (mirror_w[address] >= 0x1400 && mirror_w[address] <= 0x15FF) // mirror of $1000..$11FF
            {   memflags[address] |= MIRRORED_W;
                mirror_w[address] -= 0x400;
            } elif (mirror_w[address] >= 0x1800 && mirror_w[address] <= 0x1BFF) // mirror of $1000..$13FF
            {   memflags[address] |= MIRRORED_W;
                mirror_w[address] -= 0x800;
            } elif (mirror_w[address] >= 0x1C00 && mirror_w[address] <= 0x1DFF) // mirror of $1400..$15FF (which is itself a mirror of $1000..$11FF)
            {   memflags[address] |= MIRRORED_W;
                mirror_w[address] -= 0xC00; // 2-level mirror, resolved completely here
        }   }
        elif (memmap == MEMMAP_D)
        {   if (mirror_r[address] >= 0x1C00 && mirror_r[address] <= 0x1DFF) // mirror of $1800..$19FF
            {   mirror_r[address] -= 0x400;
            }

            if (mirror_w[address] >= 0x1C00 && mirror_w[address] <= 0x1DFF) // mirror of $1800..$19FF
            {   mirror_w[address] -= 0x400;
}   }   }   }

MODULE void e_setmemmap(void)
{   int address;

    cpuread  = e_cpuread;
    cpuwrite = ie_cpuwrite;

    // only MIRRORED_R and/or MIRRORED_W need be set for mirrored regions.

    for (address = 0; address < 32 * KILOBYTE; address++)
    {   memflags[address] = 0;
        mirror_r[address] =
        mirror_w[address] = address;

        // MEMMAP_E is not yet supported

        if
        (    address <=  0x7FF                       // ROM
         || (address >= 0x1C00 && address <= 0x1C1F) // unused
         ||  address == 0x1D20                       // randomizer #2
         || (address >= 0x1D80 && address <= 0x1DBF) // input lines (and mirrors thereof)
         || (address >= 0x1E00 && address <= 0x1E7F) // unmapped
         || (address >= 0x1F2E && address <= 0x1F3F) // unmapped
         || (address >= 0x1F6E && address <= 0x1F7F) // unmapped
         || (address >= 0x1FAE && address <= 0x1FBF) // unmapped, randomizer, unmapped
         || (address >= 0x1FC4 && address <= 0x1FC5) // unused
         ||  address >= 0x1FCA                       // R/- hardware registers, unused, randomizer, semi-mirrors, unused
        )
        {   memflags[address] |= NOWRITE;
        }

        if
        (   (address >= 0x1C00 && address <= 0x1C1F) // unused
         || (address >= 0x1D00 && address <= 0x1D1F) // PSGs (write-only?)
         || (address >= 0x1DC0 && address <= 0x1E7F) // output lines (and mirrors thereof), unmapped
         || (address >= 0x1F2E && address <= 0x1F3F) // unmapped
         || (address >= 0x1F6E && address <= 0x1F7F) // unmapped
         ||  address == 0x1FAE                       // unmapped
    // legal:            $1FAF                          1st German randomizer
         || (address >= 0x1FB0 && address <= 0x1FBF) // unmapped
         || (address >= 0x1FC0 && address <= 0x1FC9) // -/W hardware registers
    // legal:            $1FCA              ..$1FCD     R/- (read-only) hardware registers
         || (address >= 0x1FCE && address <= 0x1FD9) // unused, mirrors (not occurring)
    // legal:            $1FDA              ..$1FDB     semi-mirrors
         || (address >= 0x1FDC && address <= 0x1FE9) // mirrors (not occurring)
    // legal:            $1FEA              ..$1FEB     semi-mirrors
         || (address >= 0x1FEC && address <= 0x1FF9) // mirrors (not occurring)
    // legal:            $1FFA              ..$1FFB     semi-mirrors
         || (address >= 0x1FFC && address <= 0x1FFE) // mirrors (not occurring)
    // legal:            $1FFF                          1st English randomizer
         ||  address >= 0x2000                       // unused
        )
        {   memflags[address] |= NOREAD;
        }

        if
		(   (address >= 0x1FCA && address <= 0x1FCB)
         || (address >= 0x1FDA && address <= 0x1FDB)
         || (address >= 0x1FEA && address <= 0x1FEB)
         || (address >= 0x1FFA && address <= 0x1FFB)
        )
		{   memflags[address] |= READONCE;
        }

        if
        (   address == I_PITCH
         || address == I_NOISE

#ifdef WIN32
         || (address >= 0x1D00 && address <= 0x1D1F) // not really every byte in this range
#endif

        )
        {   memflags[address] |= AUDIBLE;
        }

        // mirrors of $1C00..$1C09 and $1C0C..$1C0F.
        // $1C0A..$1C0B are semi-mirrored.
        if
        (   (mirror_r[address] >= 0x1FD0 && mirror_r[address] <= 0x1FD9)
         || (mirror_r[address] >= 0x1FDC && mirror_r[address] <= 0x1FE9)
         || (mirror_r[address] >= 0x1FEC && mirror_r[address] <= 0x1FF9)
         || (mirror_r[address] >= 0x1FFC && mirror_r[address] <= 0x1FFE) // $1FFF is a randomizer
        )
        {   memflags[address] |= MIRRORED_R;
            mirror_r[address] &= 0xFFCF; // apply mask of %1111111111001111
        }
        if (mirror_r[address] >= 0x1C20 && mirror_r[address] <= 0x1CFF) // mirror of $1D20..$1DFF
        {   memflags[address] |= MIRRORED_R;
            mirror_r[address] += 0x100;
        }

        // mirrors of $1C00..$1C09 and $1C0C..$1C0F.
        // $1C0A..$1C0B are semi-mirrored.
        if
        (   (mirror_w[address] >= 0x1FD0 && mirror_w[address] <= 0x1FD9)
         || (mirror_w[address] >= 0x1FDC && mirror_w[address] <= 0x1FE9)
         || (mirror_w[address] >= 0x1FEC && mirror_w[address] <= 0x1FF9)
         || (mirror_w[address] >= 0x1FFC && mirror_w[address] <= 0x1FFE) // $1FFF is a randomizer
        )
        {   memflags[address] |= MIRRORED_W;
            mirror_w[address] &= 0xFFCF; // apply mask of %1111111111001111
        }
        if (mirror_w[address] >= 0x1C20 && mirror_w[address] <= 0x1CFF) // mirror of $1D20..$1DFF
        {   memflags[address] |= MIRRORED_W;
            mirror_w[address] += 0x100;
        }

        inputmirrors(address);
    }

/* Unresolved issues:
 we're assuming that PSG registers are write-only, but is that
  really correct? Yes, it is.
 how should writes to $1FFF be handled?
  a) mirror them: they will resolve to $1FCF; or...
  b) handle them as (illegal) writes to randomizer #1
  we're handling them as (b) currently.
 we're assuming $1D20 is mirrored at $1C20, but it might not be.
*/

    // this assumes fillmem() has already been called
    if (memory[0x73E] == 0x19) // buggy version of monitor
    {   memflags[0x199C] |= MIRRORED_R | MIRRORED_W;
        memflags[0x199D] |= MIRRORED_R | MIRRORED_W;
        memflags[0x199E] |= MIRRORED_R | MIRRORED_W;
        memflags[0x199F] |= MIRRORED_R | MIRRORED_W;
        memflags[0x19BC] |= MIRRORED_R | MIRRORED_W;
        memflags[0x19BD] |= MIRRORED_R | MIRRORED_W;
        memflags[0x19BE] |= MIRRORED_R | MIRRORED_W;
        memflags[0x19BF] |= MIRRORED_R | MIRRORED_W;
        mirror_r[0x199C] = mirror_w[0x199C] = 0x1D9C;
        mirror_r[0x199D] = mirror_w[0x199D] = 0x1D9D;
        mirror_r[0x199E] = mirror_w[0x199E] = 0x1D9E;
        mirror_r[0x199F] = mirror_w[0x199F] = 0x1D9F;
        mirror_r[0x19BC] = mirror_w[0x19BC] = 0x1DBC;
        mirror_r[0x19BD] = mirror_w[0x19BD] = 0x1DBD;
        mirror_r[0x19BE] = mirror_w[0x19BE] = 0x1DBE;
        mirror_r[0x19BF] = mirror_w[0x19BF] = 0x1DBF;
    } // elif (memory[0x73E] != 0x1D) assert(0); // not fixed version either, so panic!
}

MODULE void inputmirrors(int address)
{   // write mirrors
    if (    mirror_w[address] >= 0x1E81 && mirror_w[address] <= 0x1EFF)
    {   memflags[address] |= MIRRORED_W;
        mirror_w[address] = 0x1E80;
    }
    if (             address  == 0x1E80) // only applies to real $1E80, not mirrors thereof!
    {   memflags[address] |= NOREAD;
    }

    // read mirrors
    if (    mirror_r[address] >= 0x1E81 && mirror_r[address] <= 0x1E97)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1E98 && mirror_r[address] <= 0x1E9B)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x10;
    } elif (mirror_r[address] >= 0x1E9C && mirror_r[address] <= 0x1EA7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1EA8 && mirror_r[address] <= 0x1EAE)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x20;
    } elif (mirror_r[address] >= 0x1EAF && mirror_r[address] <= 0x1EB7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1EB8 && mirror_r[address] <= 0x1EBB)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x30;
    } elif (mirror_r[address] >= 0x1EBC && mirror_r[address] <= 0x1EC7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1EC8 && mirror_r[address] <= 0x1ECE)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x40;
    } elif (mirror_r[address] >= 0x1ECF && mirror_r[address] <= 0x1ED7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1ED8 && mirror_r[address] <= 0x1EDB)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x50;
    } elif (mirror_r[address] >= 0x1EDC && mirror_r[address] <= 0x1EE7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1EE8 && mirror_r[address] <= 0x1EEE)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x60;
    } elif (mirror_r[address] >= 0x1EEF && mirror_r[address] <= 0x1EF7)
    {   memflags[address] |= NOWRITE;
    } elif (mirror_r[address] >= 0x1EF8 && mirror_r[address] <= 0x1EFB)
    {   memflags[address] |= MIRRORED_R;
        mirror_r[address] -= 0x70;
    } elif (mirror_r[address] >= 0x1EFC && mirror_r[address] <= 0x1EFF)
    {   memflags[address] |= NOWRITE;
}   }

EXPORT void cpu_reset(void)
{   int i;

    if (machine == ELEKTOR)
    {   iar   = (memory[0x8BE] * 256) + memory[0x8BF];
        for (i = 0x1D00; i <= 0x1D1F; i++)
        {   memory[i] = 0; // PSGs are cleared at reset
        }
        playsound(TRUE);
    } else
    {   iar   = 0;
        for (i = 0; i <= 6; i++)
        {   r[i] = 0;
        }
        for (i = 0; i <= 7; i++)
        {   ras[i] = 0;
        }
        psu   =
        psl   = 0;
    }

    interrupt = FALSE;
    page      = 0;
    elapsed   = 0;
    frames    = 0;
    oldframes = 0;
    overcalc  = 0;
}

MODULE void fillmem(void)
{   int i;

    // assert(!crippled);
    // assert(!inframe);

    for (i = 0; i <= 0x7FFF; i++)
    {   memory[i] = 0;
    }

    if (machine == ARCADIA)
    {   for (i = 0x1909; i <= 0x197F; i++)
        {   memory[i] = 0xC0; // some of them (randomly determined?) are $40 though
        }
        for (i = 0x19C0; i <= 0x19F7; i++)
        {   memory[i] = 0xFF;
    }   }
    elif (machine == ELEKTOR)
    {   for (i = 0; i <= 0x7FF; i++)
        {   memory[i] = bios[i];
        }
        // make $8B9..$8BA $0903
        memory[0x8B9] = 0x09;
        memory[0x8BA] = 0x03;
    }
    game = FALSE;
    ax[0] =
    ay[0] =
    ax[1] =
    ay[1] = 128;
}

EXPORT FLAG engine_load(void)
{   FILE*  LocalHandle /* = NULL */ ;

    filesize = (int) getsize(thefilename);

    alloc_iobuffer((ULONG) filesize);
    if (!(LocalHandle = fopen((char *) thefilename, "rb"))) // just cast for lint
    {
#ifdef VERBOSE
        OPENCONSOLE; printf("Can't open %s for reading!\n", thefilename); REACTIVATE;
#endif
        return FALSE;
    }
    if (fread(IOBuffer, (size_t) filesize, 1, LocalHandle) != 1)
    {   fclose(LocalHandle);
        // LocalHandle = NULL;
        return FALSE;
    }
    fclose(LocalHandle);
    // LocalHandle = NULL;

    if (!parse_bytes(TRUE))
    {   return FALSE;
    }

    // assert(MainWindowPtr);

    emulating = TRUE;
    updatemenus();
    updatesmlgads();
    updatebiggads();
    settitle();
    redrawscreen();

    return TRUE;
}

EXPORT void engine_save(int kind, FLAG updatetitle)
{   FILE* LocalHandle /* = NULL */ ;
    int i;
    UWORD loadaddress,
          endaddress;

    if (kind == KIND_BIN || kind == KIND_PGM || kind == KIND_TVC)
    {   alloc_iobuffer((ULONG) ROMSIZE_MAX);
    } else
    {   /* assert(kind == KIND_EAS || kind == KIND_EAR
               || kind == KIND_INS || kind == KIND_INR
               || kind == KIND_TVS || kind == KIND_TVR
                 ); */
        alloc_iobuffer((ULONG) SNPSIZE_MAX);
    }

    offset = 0;

    // magic byte (1 byte)
    switch(kind)
    {
    case KIND_PGM:
        WriteByte( 0x0); // indeterminate opcode (LODZ,r0)
    acase KIND_TVC:
        WriteByte( 0x2); // valid opcode (LODZ,r2) :-(
    acase KIND_EAS:
        WriteByte(0x10); // unused opcode
    acase KIND_EAR:
        WriteByte(0x11); // unused opcode
    acase KIND_INS:
        WriteByte(0xB6); // unused opcode
    acase KIND_INR:
        WriteByte(0xB7); // unused opcode
    acase KIND_TVS:
        WriteByte(0x90); // unused opcode
    acase KIND_TVR:
        WriteByte(0x91); // unused opcode
    adefault:
        // assert(kind == KIND_BIN);
    break;
    }

    if (kind != KIND_BIN && kind != KIND_PGM && kind != KIND_TVC)
    {   // state
        WriteInt((UWORD) romsize);
        WriteInt((UWORD) iar);
        WriteByte((UBYTE) page);
        WriteByte(psu);
        WriteByte(psl);
        for (i = 0; i < 8; i++)
        {   WriteInt(ras[i]);
        }
        for (i = 0; i < 7; i++)
        {   WriteByte(r[i]);
        }

        // assert(offset == 31);

        if (machine == ARCADIA)
        {   WriteByte(2); // version ID (2 means V4.32+)
            WriteByte((UBYTE) overcalc);

            // UVI/RAM dump
            for (i = 0x1800; i <= 0x1908; i++) /* 265 bytes */ WriteByte(memory[i]);
            for (i = 0x1980; i <= 0x19BF; i++) /*  64 bytes */ WriteByte(memory[i]);
            for (i = 0x19F8; i <= 0x1AFF; i++) /* 264 bytes */ WriteByte(memory[i]);
                                             /* = 593 bytes */
        } elif (machine == INTERTON)
        {   WriteByte(3); // version ID (3 means V4.32+)
            WriteByte((UBYTE) overcalc);

            for (i = 0x1000; i <= 0x15FF; i++) // 1.5K
            {   WriteByte(memory[i]);
            }
            for (i = 0x1800; i <= 0x1DFF; i++) // 1.5K
            {   WriteByte(memory[i]);
            }
            for (i = 0x1E88; i <= 0x1E8E; i++) // 7 bytes
            {   WriteByte(memory[i]);
            }
            for (i = 0x1F00; i <= 0x1F2D; i++) // 46 bytes
            {   WriteByte(memory[i]);
            }
            for (i = 0x1F40; i <= 0x1F6D; i++) // 46 bytes
            {   WriteByte(memory[i]);
            }
            for (i = 0x1F80; i <= 0x1FAD; i++) // 46 bytes
            {   WriteByte(memory[i]);
            }
            for (i = 0x1FC0; i <= 0x1FC3; i++) // 4 bytes
            {   WriteByte(memory[i]);
            }
            for (i = 0x1FC6; i <= 0x1FCD; i++) // 8 bytes
            {   WriteByte(memory[i]);
		}   }
		else
        {   // assert(machine == ELEKTOR);
        
			WriteByte(3); // version ID (3 means V4.32+)
            WriteByte((UBYTE) overcalc);
            WriteInt((SWORD) whichgame);

            for (i = 0x800; i <= 0x1FFF; i++)
            {   WriteByte(memory[i]);
	}   }   }

    // assert(romsize <= ROMSIZE_MAX);

    if (machine == ELEKTOR)
    {   if (kind == KIND_PGM)
        {   // assert(offset == 1);
            WriteByte(memory[0x8BE]);
            WriteByte(memory[0x8BF]);
            for (i = 3; i <= 0x7FF; i++)
            {   WriteByte(0);
            }
            for (i = 0x800; i < romsize; i++)
            {   WriteByte(memory[i]);
        }   }
        elif (kind == KIND_TVC)
        {   // find the first nonzero byte
            loadaddress = // fallback for the rather theoretical case where it is completely empty from $8C0 onwards
            endaddress  =
            offset      = 0x8C0;
            for (i = 0x8C0; i < romsize; i++)
            {   if (ReadByte() != 0)
                {   loadaddress = i;
                    break;
            }   }
            // find the last nonzero byte
            for (i = loadaddress; i < romsize; i++)
            {   if (ReadByte() != 0)
                {   endaddress = i;
            }   }
            // write out the header
            offset = 1;
            WriteInt(loadaddress);    // bytes 1 and 2
            WriteByte(memory[0x8BE]); // byte 3
            WriteByte(memory[0x8BF]); // byte 4
            // write out the body
            for (i = loadaddress; i <= endaddress; i++)
            {   WriteByte(memory[i]);
            }
#ifdef VERBOSE
        printf("Load  address is $%lX.\n", loadaddress);
        printf("Start address is $%lX.\n", (memory[0x8BE] * 256) + memory[0x8BF]);
        REACTIVATE;
#endif
    }   }
    elif (machine == INTERTON || romsize <= 4096)
    {   for (i = 0; i < romsize; i++)
        {   WriteByte(memory[i]);              // $0000..$0FFF -> $0000..$0FFF
    }   }
    elif (romsize <= 8192)
    {   if (machine == ARCADIA)
        {   for (i = 0; i < 4096; i++)
            {   WriteByte(memory[i]);          // $0000..$0FFF -> $0000..$0FFF
            }
            for (i = 0; i < romsize - 4096; i++)
            {   WriteByte(memory[8192 + i]);   // $2000..$2FFF -> $1000..$1FFF
        }   }
        else
        {   // assert(machine == INTERTON);
            for (i = 0; i < 0x15FF; i++)
            {   WriteByte(memory[i]);          // $0000..$15FF -> $0000..$15FF
    }   }   }
    elif (romsize <= 12 * KILOBYTE)
    {   for (i = 0; i < 4096; i++)
        {   WriteByte(memory[i]);              // $0000..$0FFF -> $0000..$0FFF
        }
        for (i = 0; i < 4096; i++)
        {   WriteByte(memory[0x2000 + i]);     // $2000..$2FFF -> $1000..$1FFF
        }
        for (i = 0; i < romsize - 8192; i++)
        {   WriteByte(memory[0x4000 + i]); // $4000..$4FFF -> $2000..$2FFF
    }   }
    else
    {   // assert(romsize <= 16 * KILOBYTE);
        for (i = 0; i < 4096; i++)
        {   WriteByte(memory[i]);          // $0000..$0FFF -> $0000..$0FFF
        }
        for (i = 0; i < 4096; i++)
        {   WriteByte(memory[0x2000 + i]); // $2000..$2FFF -> $1000..$1FFF
        }
        for (i = 0; i < 4096; i++)
        {   WriteByte(memory[0x4000 + i]); // $4000..$4FFF -> $2000..$2FFF
        }
        for (i = 0; i < romsize - (12 * KILOBYTE); i++)
        {   WriteByte(memory[0x6000 + i]); // $6000..$6FFF -> $3000..$3FFF
    }   }

    if ((LocalHandle = fopen(thefilename, "wb")))
    {   DISCARD fwrite(IOBuffer, (size_t) offset, 1, LocalHandle);
        DISCARD fclose(LocalHandle);
        // LocalHandle = NULL;
    } else
    {   beep();
        free_iobuffer();
        return;
    }
    free_iobuffer();

#ifdef AMIGA
    if (icons)
    {   switch(kind)
        {
        case KIND_BIN:
            // assert(machine != ELEKTOR);
            if (machine == ARCADIA)
            {   writeicon("PROGDIR:icons/icon_bin_a");
            } else
            {   // assert(machine == INTERTON);
                writeicon("PROGDIR:icons/icon_bin_i");
            }
        acase KIND_PGM:
            // assert(machine == ELEKTOR);
            writeicon("PROGDIR:icons/icon_pgm");
        acase KIND_TVC:
            // assert(machine == ELEKTOR);
            writeicon("PROGDIR:icons/icon_tvc");
        acase KIND_EAS:
            // assert(machine == ARCADIA);
            writeicon("PROGDIR:icons/icon_eas");
        acase KIND_EAR:
            // assert(machine == ARCADIA);
            writeicon("PROGDIR:icons/icon_ear");
        acase KIND_INS:
            // assert(machine == INTERTON);
            writeicon("PROGDIR:icons/icon_ins");
        acase KIND_INR:
            // assert(machine == INTERTON);
            writeicon("PROGDIR:icons/icon_inr");
        acase KIND_TVS:
            // assert(machine == ELEKTOR);
            writeicon("PROGDIR:icons/icon_tvs");
        acase KIND_TVR:
            // assert(machine == ELEKTOR);
            writeicon("PROGDIR:icons/icon_tvr");
        adefault:
            // assert(0);
        break;
    }   }
#endif

    if
    (   kind != KIND_EAR
     && kind != KIND_INR
     && kind != KIND_TVR
    )
    {   if (updatetitle)
        {   settitle();
        }
        return;
    }

    if (!(MacroHandle = fopen(thefilename, "a+b")))
    {   beep();
        return;
    }

    // assert(updatetitle == TRUE);
    settitle();
    recmode = RECMODE_RECORD;
    updatesmlgad(GADPOS_MACRO, (ULONG) recmode, TRUE);
}

MODULE UWORD ReadInt(void)
{   UWORD result;

    // big endian 16-bit word
    result = (UWORD) (256 * IOBuffer[offset])
                          + IOBuffer[offset + 1];
    offset += 2;
    return(result);
}
MODULE UBYTE ReadByte(void)
{   UBYTE result;

    result = IOBuffer[offset++];
    return(result);
}
MODULE void WriteInt(UWORD what)
{   // big endian 16-bit word
    IOBuffer[offset]     = what / 256;
    IOBuffer[offset + 1] = what % 256;
    offset += 2;
}
MODULE void WriteByte(UBYTE what)
{   IOBuffer[offset++]   = what;
}

MODULE void a_cpuwrite(int address, UBYTE data)
{   // assert(address < 32768);
    // assert(machine == ARCADIA);

    // Writes to memory from the CPU always go through this routine.

    // handle mirroring

    if (memflags[address] & MIRRORED_W)
    // $1000..$17FF, $1B00..$1FFF, $3000..$3FFF, $5000..$5FFF, $7000..$7FFF
    {   if (logwrites)
        {   getfriendly(mirror_w[address]);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is writing $%X to mirrored address $%lX (resolves to %s)!\n\n", iar, rast, data, address, friendly);
            REACTIVATE;
        }
        address = mirror_w[address];
    }

    // check for illegal writes

    if (memflags[address] & NOWRITE)
    {   if (logwrites)
        {   getfriendly(address);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is attempting to write $%X to address %s!\n\n", iar, rast, data, friendly);
            REACTIVATE;
        }

        return;
    }

    if (address == wp && data != memory[wp])
    {   getfriendly(wp);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is writing $%X to %s!\n\n", page + iar, rast, data, friendly);
        REACTIVATE;
        runto();
    }

    memory[address] = data; // would this be better before the above section?

    if (memflags[address] & AUDIBLE)
    {   playsound(FALSE);
}   }

MODULE void ie_cpuwrite(int address, UBYTE data)
{   // assert(address < 32768);
    // assert(machine == INTERTON || machine == ELEKTOR);

    // Writes to memory from the CPU always go through this routine.

    // handle mirroring

    if (memflags[address] & MIRRORED_W)
    {   if (logwrites)
        {   getfriendly((int) mirror_w[address]);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is writing $%X to mirrored address $%lX (resolves to %s)!\n\n", iar, rast, data, address, friendly);
            REACTIVATE;
        }
        address = (int) mirror_w[address];
    }

    /* check for illegal writes */

    if (memflags[address] & NOWRITE)
    {   if (logwrites)
        {   getfriendly(address);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is attempting to write $%X to address %s!\n\n", iar, rast, data, friendly);
            REACTIVATE;
        }

        return;
    }

    if (address == wp && data != memory[wp])
    {   getfriendly(wp);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is writing $%X to %s!\n\n", page + iar, rast, data, friendly);
        REACTIVATE;
        runto();
    }

    // The game can never write to semi-mirrored registers, as they are
    // all read-only. They can ONLY be set by the PVI!

    memory[address] = data;

    // we know that semi-mirrored registers are never audible
    if (memflags[address] & AUDIBLE)
    {   playsound(FALSE);
}   }

MODULE UBYTE a_cpuread(int address)
{   // assert(address < 32768);
    // assert(machine == ARCADIA);

    /* Reads to memory from the UVI do not go through this routine.
    Strictly speaking, we should use this routine for ALL CPU read
    accesses, eg. reading opcodes/operands, relative addresses, etc.
    Currently, we only use it for absolute accesses: LODA, STRA, etc.

    Testing on an authentic Emerson Arcadia 2001 console has been
    undertaken to make the read/write property emulation as accurate as
    possible. However, this has not occurred for the Interton VC 4000.

    Reads of read-once registers, even if it is the second or later read,
    are not logged as illegal reads.

    Reads of unused ROM areas (eg. $0800..$0FFF for 2K ROMs) are not
    logged as illegal reads. */

    // handle mirroring

    if (memflags[address] & MIRRORED_R)
    // $1000..$17FF, $1B00..$1FFF, $3000..$3FFF, $5000..$5FFF, $7000..$7FFF
    {   if (logreads)
        {   getfriendly(mirror_r[address]);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) read from mirrored address $%lX (resolves to %s)!\n\n", iar, rast, address, friendly);
            REACTIVATE;
        }
        address = mirror_r[address];
    }

    if (memflags[address] & NOREAD)
    {   t = 0xFF; // some really return eg. $40, $C0 instead of $FF
    } else
    {   t = memory[address];
    }
    if (memflags[address] & READONCE)
    {   memory[address] = 0xFF;
        // we really should use uviwrite() for this, but if there's a watchpoint set, that would mean breaking in the middle of executing a CPU instruction!
    }

    // handle illegal reads

    if (logreads)
    {   if (memflags[address] & NOREAD)
        {   getfriendly(address);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is attempting to read from address %s!\n\n", iar, rast, friendly);
            REACTIVATE;
    }   }

    if (watchreads && address == wp)
    {   getfriendly(wp);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is reading $%X from %s!\n\n", page + iar, rast, t, friendly);
        REACTIVATE;
        runto();
    }

    return(t);
}

MODULE UBYTE i_cpuread(int address)
{   // assert(address < 32768);
    // assert(machine == INTERTON);

    /* Reads of read-once registers, even if it is the second or later
    read, are not logged as illegal reads.

    Reads of unused ROM areas (eg. $0800..$0FFF for 2K ROMs) are not
    logged as illegal reads. */

    // handle mirroring

    if (memflags[address] & MIRRORED_R)
    {   if (logreads)
        {   getfriendly((int) mirror_r[address]);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) read from mirrored address $%lX (resolves to %s)!\n\n", iar, rast, address, friendly);
            REACTIVATE;
        }
        address = mirror_r[address];
    }

    if (memflags[address] & NOREAD)
    {   t = 0;
    } else
    {   t = memory[address];
    }

    if (memflags[address] & READONCE)
    {   memory[address] = 0;
        // we deliberately don't zero the semi-mirrors of this, that is
        // why they are only semi-mirrors.
        // we really should use pviwrite() for this, but if there's a
        // watchpoint set, that would mean breaking in the middle of
        // executing a CPU instruction.
    }

    // handle illegal reads
    // GRNDPRIX attempts to read from $1F6E..$1F70!
    // not sure whether NOISE ($1E80) is R/W or -/W! (assuming R/W)

    if (logreads && (memflags[address] & NOREAD))
    {   getfriendly(address);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is attempting to read from address %s!\n\n", iar, rast, friendly);
        REACTIVATE;
    }

    if (watchreads && address == wp)
    {   getfriendly(wp);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is reading $%X from %s!\n\n", page + iar, rast, t, friendly);
        REACTIVATE;
        runto();
    }

    return(t);
}

MODULE UBYTE e_cpuread(int address)
{   // assert(address < 32768);
    // assert(machine == INTERTON);

    /* Reads of read-once registers, even if it is the second or later
    read, are not logged as illegal reads. */

    // handle mirroring

    if (memflags[address] & MIRRORED_R)
    {   if (logreads)
        {   getfriendly((int) mirror_r[address]);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) read from mirrored address $%lX (resolves to %s)!\n\n", iar, rast, address, friendly);
            REACTIVATE;
        }
        address = mirror_r[address];
    }

    if
    (   address == E_RANDOM1E
     || address == E_RANDOM1G
     || address == E_RANDOM2
    )
    {   if (recmode == RECMODE_PLAY)
        {   t = loadrand();
        } else
        {   t = rand() % 256;
            if (recmode == RECMODE_RECORD)
            {   saverand(t);
    }   }   }
    elif (memflags[address] & NOREAD)
    {   t = 0;
    } else
    {   t = memory[address];
    }

    // handle read-once

    if (memflags[address] & READONCE)
    {   memory[address] = 0;
        // we deliberately don't zero the semi-mirrors of this, that is
        // why they are only semi-mirrors.
        // we really should use pviwrite() for this?
    }

    // handle illegal reads
    // GRNDPRIX attempts to read from $1F6E..$1F70!
    // not sure whether NOISE ($1E80) is R/W or -/W! (assuming R/W)

    if (logreads)
    {   if (memflags[address] & NOREAD)
        {   getfriendly((UWORD) address);
            OPENCONSOLE;
            printf("Instruction at $%lX (raster %ld) is attempting to read from address %s!\n\n", iar, rast, friendly);
            REACTIVATE;
    }   }

    if (watchreads && address == wp)
    {   getfriendly(wp);
        OPENCONSOLE;
        printf("Instruction at $%lX (raster %ld) is reading $%X from %s!\n\n", page + iar, rast, t, friendly);
        REACTIVATE;
        runto();
    }

    return(t);
}

MODULE void view_pviscreen(void)
{   // assert(machine == INTERTON || machine == ELEKTOR);

    UWORD where = 0x1F80;
    UBYTE data;
    int   i, j;

    OPENCONSOLE;

    for (j = 0; j < 20; j++)
    {   hex2(astring, where);
        hex1(disp[0], memory[where]);
        hex1(disp[1], memory[where + 1]);
        printf("%s: %s %s ", astring, disp[0], disp[1]);

        data = memory[where++];
        for (i = 0; i < 8; i++)
        {   if (data & (128 >> i))
            {   printf("#");
            } else
            {   printf(".");
        }   }
        printf(" ");
        data = memory[where++];
        for (i = 0; i < 8; i++)
        {   if (data & (128 >> i))
            {   printf("#");
            } else
            {   printf(".");
        }   }
        printf("\n");
    }

    for (i = 0; i < 5; i++)
    {   hex1(disp[i], memory[0x1FA8 + i]);
    }
    printf("1FA8: %s %s %s %s %s\n\n", disp[0], disp[1], disp[2], disp[3], disp[4]);

    REACTIVATE;
}

#ifdef WIN32
EXPORT void view_upperscreen(void)
{   SLONG x, y;

    OPENCONSOLE;

    if (machine == INTERTON || machine == ELEKTOR)
    {   view_pviscreen();
        return;
    }

    for (y = 0; y <= 12; y++)
    {   hex2(astring, (UWORD) (A_OFFSET_UPPERSCREEN + (y * 16)));
        for (x = 0; x <= 15; x++)
        {   hex1(disp[x], memory[A_OFFSET_UPPERSCREEN + x + (y * 16)]);
        }
        printf
        (   "$%s: %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",
            astring,
            disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
            disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
        );
    }
    printf("\n");

    REACTIVATE;
}
EXPORT void view_lowerscreen(void)
{   SLONG x, y;

    // assert(machine == ARCADIA);

    OPENCONSOLE;

    for (y = 0; y <= 12; y++)
    {   hex2(astring, (UWORD) (A_OFFSET_LOWERSCREEN + (y * 16)));
        for (x = 0; x <= 15; x++)
        {   hex1(disp[x], memory[A_OFFSET_LOWERSCREEN + x + (y * 16)]);
        }
        printf
        (   "$%s: %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",
            astring,
            disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
            disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
        );
    }
    printf("\n");

    REACTIVATE;
}
#endif
#ifdef AMIGA
EXPORT void view_screen(void)
{   SLONG x, y;

    if (machine == INTERTON)
    {   view_pviscreen();
        return;
    }

    for (y = 0; y <= 12; y++)
    {   hex2(astring, (UWORD) (A_OFFSET_UPPERSCREEN + (y * 16)));
        for (x = 0; x <= 15; x++)
        {   hex1(disp[x], memory[A_OFFSET_UPPERSCREEN + x + (y * 16)]);
        }
        printf
        (   "$%s: %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",
            astring,
            disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
            disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
        );
    }
    for (y = 0; y <= 12; y++)
    {   hex2(astring, (UWORD) (A_OFFSET_LOWERSCREEN + (y * 16)));
        for (x = 0; x <= 15; x++)
        {   hex1(disp[x], memory[A_OFFSET_LOWERSCREEN + x + (y * 16)]);
        }
        printf
        (   "$%s: %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",
            astring,
            disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
            disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
        );
    }
    printf("\n");
}
#endif

EXPORT void view_cram(void)
{   int i, j,
        where;

    if
    (   machine != INTERTON
     || (memmap != MEMMAP_C && memmap != MEMMAP_D)
    )
    {   return;
    }

    OPENCONSOLE;

    if (memmap == MEMMAP_C)
    {   where = 0x1000; // 1K ($1000..$13FF)
    } else
    {   // assert(memmap == MEMMAP_D);
        where = 0x1800; // 1K ($1800..$1BFF)
    }
    for (i = where; i <= where + 1023; i += 16)
    {   hex2(astring, (UWORD) i);
        for (j = 0; j <= 15; j++)
        {   hex1(disp[j], memory[i + j]);
        }
        printf("$%s: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                astring,
                disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );
    }
    printf("\n");

    REACTIVATE;
}

EXPORT void view_allmemory(void)
{   int i, j,
        max;

    if (machine == ARCADIA)
    {   max = 0x6FFF;
        // no need to show $7000..$7FFF.
        // perhaps we should suppress showing $3000..$3FFF and
        // $5000..$5FFF.
    } else
    {   // assert(machine == INTERTON || machine == ELEKTOR);
        max = 0x1FFF;
    }

    OPENCONSOLE;

    for (i = 0; i <= max; i += 16)
    {   hex2(astring, (UWORD) i);
        for (j = 0; j <= 15; j++)
        {   hex1(disp[j], memory[mirror_r[i + j]]);
        }
        printf("$%s: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                astring,
                disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );
    }
    printf("\n");

    REACTIVATE;
}

EXPORT void view_mram(void)
{   int i, j;

    OPENCONSOLE;

    if (machine == ARCADIA)
    {   for (i = 0; i < 16; i++)
        {   hex1(disp[i], memory[0x18D0 + i]);
        }
        printf("$18D0: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
               disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
               disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );

        for (i = 0; i < 16; i++)
        {   hex1(disp[i], memory[0x18E0 + i]);
        }
        printf("$18E0: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
               disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
               disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );

        for (i = 0; i < 4; i++)
        {   hex1(disp[i], memory[0x18F8 + i]);
        }
        printf("$18F8:                         %s %s %s %s\n",
               disp[0], disp[1],  disp[2],  disp[3]
              );

        for (i = 0; i < 16; i++)
        {   hex1(disp[i], memory[0x1AD0 + i]);
        }
        printf("$1AD0: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
               disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
               disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );

        for (i = 0; i < 16; i++)
        {   hex1(disp[i], memory[0x1AE0 + i]);
        }
        printf("$1AE0: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n\n",
               disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
               disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );
    } else
    {   if (machine == ELEKTOR)
        {   // this is only designed for the expanded ("F") version, not
            // the basic ("E") version.

            // monitor RAM
            for (i = 0x800; i <= 0x8BF; i += 16)
            {   hex2(astring, (UWORD) i);
                for (j = 0; j <= 15; j++)
                {   hex1(disp[j], memory[i + j]);
                }
                printf("$%s: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                       astring,
                       disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                       disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
                      );
            }
            printf("\n");

            // user RAM
            for (i = 0x8C0; i <= 0x15FF; i += 16)
            {   hex2(astring, (UWORD) i);
                for (j = 0; j <= 15; j++)
                {   hex1(disp[j], memory[i + j]);
                }
                printf("$%s: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                       astring,
                       disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                       disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
                      );
            }
            printf("\n");

            // user RAM
            // 8 bytes in this range are actually obscured RAM, so
            // shouldn't really be shown.
            for (i = 0x1800; i <= 0x1BFF; i += 16)
            {   hex2(astring, (UWORD) i);
                for (j = 0; j <= 15; j++)
                {   hex1(disp[j], memory[i + j]);
                }
                printf("$%s: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                       astring,
                       disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                       disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
                      );
            }
            printf("\n");
        }

        hex1(disp[0], memory[0x1F0E]);
        hex1(disp[1], memory[0x1F0F]);
        printf("$1F0E:                                            %s %s\n",
                disp[0], disp[1]
              );

        hex1(disp[0], memory[0x1F1E]);
        hex1(disp[1], memory[0x1F1F]);
        printf("$1F1E:                                            %s %s\n",
                disp[0], disp[1]
              );

        hex1(disp[0], memory[0x1F4E]);
        hex1(disp[1], memory[0x1F4F]);
        printf("$1F4E:                                            %s %s\n",
                disp[0], disp[1]
               );

        for (i = 0; i < 16; i++)
        {   hex1(disp[i], memory[0x1F50 + i]);
        }
        printf("$1F50: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s %s %s\n",
                disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                disp[8], disp[9], disp[10], disp[11], disp[12], disp[13], disp[14], disp[15]
              );

        for (i = 0; i < 14; i++)
        {   hex1(disp[i], memory[0x1F60 + i]);
        }
        printf("$1F60: %s %s %s %s %s %s %s %s  %s %s %s %s %s %s\n",
                disp[0], disp[1],  disp[2],  disp[3],  disp[4],  disp[5],  disp[6],  disp[7],
                disp[8], disp[9], disp[10], disp[11], disp[12], disp[13]
              );

        hex1(disp[0], memory[0x1FAD]);
        printf("$1FAD:                                         %s\n\n",
                disp[0]
              );
    }

    REACTIVATE;
}

EXPORT void view_psgs(void)
{   // assert(machine == ELEKTOR);

    OPENCONSOLE;
    printf
    (   "---------------PSG #1---------------- "
        "---------------PSG #2----------------\n"
    );

    hex2(disp[0], (UWORD) ((memory[E_PITCHA1_H] * 256) + memory[E_PITCHA1_L]));
    hex1(disp[1],  memory[E_PITCHD1      ]);
    hex2(disp[2], (UWORD) ((memory[E_PITCHA2_H] * 256) + memory[E_PITCHA2_L]));
    hex1(disp[3],  memory[E_PITCHD2      ]);
    printf
    (   "PITCHA1:      %s PITCHD1:        %s PITCHA2:      %s PITCHD2:        %s\n",
         disp[0],         disp[1],           disp[2],         disp[3]
    );

    hex2(disp[0], (UWORD) ((memory[E_PITCHB1_H] * 256) + memory[E_PITCHB1_L]));
    hex1(disp[1],  memory[E_ENABLE1      ]);
    hex2(disp[2], (UWORD) ((memory[E_PITCHB2_H] * 256) + memory[E_PITCHB2_L]));
    hex1(disp[3],  memory[E_ENABLE2      ]);
    printf
    (   "PITCHB1:      %s ENABLE1:        %s PITCHB2:      %s ENABLE2:        %s\n",
         disp[0],         disp[1],           disp[2],         disp[3]
    );

    hex2(disp[0], (UWORD) ((memory[E_PITCHC1_H] * 256) + memory[E_PITCHC1_L]));
    hex2(disp[1], (UWORD) ((memory[E_PERIOD1_H] * 256) + memory[E_PERIOD1_L]));
    hex2(disp[2], (UWORD) ((memory[E_PITCHC2_H] * 256) + memory[E_PITCHC2_L]));
    hex2(disp[3], (UWORD) ((memory[E_PERIOD2_H] * 256) + memory[E_PERIOD2_L]));
    printf
    (   "PITCHC1:      %s PERIOD1:      %s PITCHC2:      %s PERIOD2:      %s\n",
         disp[0],         disp[1],         disp[2],         disp[3]
    );

    hex1(disp[0], memory[E_AMPLITUDEA1]);
    hex1(disp[1], memory[E_SHAPE1     ]);
    hex1(disp[2], memory[E_AMPLITUDEA2]);
    hex1(disp[3], memory[E_SHAPE2     ]);
    printf
    (   "AMPLITUDEA1:    %s SHAPE1:         %s AMPLITUDEA2:    %s SHAPE2:         %s\n",
         disp[0],           disp[1],           disp[2],           disp[3]
    );

    hex1(disp[0], memory[E_AMPLITUDEB1]);
    hex1(disp[1], memory[E_PORTA1     ]);
    hex1(disp[2], memory[E_AMPLITUDEB2]);
    hex1(disp[3], memory[E_PORTA2     ]);
    printf
    (   "AMPLITUDEB1:    %s PORTA1:         %s AMPLITUDEB2:    %s PORTA2:         %s\n",
         disp[0],           disp[1],           disp[2],           disp[3]
    );

    hex1(disp[0], memory[E_AMPLITUDEC1]);
    hex1(disp[1], memory[E_PORTB1     ]);
    hex1(disp[2], memory[E_AMPLITUDEC2]);
    hex1(disp[3], memory[E_PORTB2     ]);
    printf
    (   "AMPLITUDEC1:    %s PORTB1:         %s AMPLITUDEC2:    %s PORTB2:         %s\n\n",
         disp[0],           disp[1],           disp[2],           disp[3]
    );

    REACTIVATE;
}

EXPORT void calcrunningtime(void)
{   PERSIST int hours,
                minutes,
                seconds,
                micros; // all PERSISTent for speed

    if (region == REGION_NTSC)
    {   seconds =          frames / 60 ; // how many seconds
        micros  = 16667 * (frames % 60); // microseconds
    } else
    {   // assert(region == REGION_PAL);
        seconds =          frames / 50 ; // how many seconds
        micros  = 20000 * (frames % 50); // microseconds
    }
    hours   = (seconds / 3600) % 100; // resets to 00 hours after 100 hours
    minutes = (seconds % 3600) / 60;
    seconds %= 60;

    timestring[0]  = '0' + (hours   / 10);
    timestring[1]  = '0' + (hours   % 10);
    timestring[3]  = '0' + (minutes / 10);
    timestring[4]  = '0' + (minutes % 10);
    timestring[6]  = '0' + (seconds / 10);
    timestring[7]  = '0' + (seconds % 10);
    timestring[9]  = '0' + (micros  / 100000);
    timestring[10] = '0' + (micros  % 100000) / 10000;
}

EXPORT void view_xvi(void)
{   decimal(xvistring[0], elapsed + cycles);
    decimal(xvistring[1], rast);
    decimal(xvistring[2], frames);
    calcrunningtime();

    OPENCONSOLE;
    printf
    (   "Clock:  %s Raster: %s Frame:  %s Time:  %s\n",
        xvistring[0],
        xvistring[1],
        xvistring[2],
        timestring
    );

    if (psu & PSU_F)
    {   strcpy(astring, " On");
    } else
    {   strcpy(astring, "Off");
    }
    if (psu & PSU_S)
    {   strcpy(bstring, " On");
    } else
    {   strcpy(bstring, "Off");
    }
    printf
    (   "Flag:          %s Sense:         %s\n",
         astring,          bstring
    );

    if (machine == ARCADIA)
    {   hex1(disp[0], memory[A_CONSOLE      ]);
        hex1(disp[1], memory[A_PITCH        ]);
        hex1(disp[2], memory[A_VOLUME       ]);
        printf
        (   "CONSOLE:        %s PITCH:          %s VOLUME:         %s\n",
            disp[0],           disp[1],           disp[2]
        );

        hex1(disp[0], memory[A_RESOLUTION   ]);
        hex1(disp[1], memory[A_BGCOLOUR     ]);
        hex1(disp[2], memory[A_VSCROLL      ]);
        hex1(disp[3], memory[A_CHARLINE     ]);
        printf
        (   "RESOLUTION:     %s BGCOLOUR:       %s VSCROLL:        %s CHARLINE:       %s\n",
            disp[0],           disp[1],           disp[2],           disp[3]
        );

        hex1(disp[0], memory[A_BGCOLLIDE    ]);
        hex1(disp[1], memory[A_SPRITECOLLIDE]);
        hex1(disp[2], memory[A_SPRITES01CTRL]);
        hex1(disp[3], memory[A_SPRITES23CTRL]);
        printf
        (   "BGCOLLIDE:      %s SPRITECOLLIDE:  %s SPRITES01CTRL:  %s SPRITES23CTRL:  %s\n",
             disp[0],           disp[1],           disp[2],           disp[3]
        );

            hex1(disp[0], memory[A_SPRITE0X     ]);
            hex1(disp[1], memory[A_SPRITE0Y     ]);
            hex1(disp[2], memory[A_SPRITE1X     ]);
            hex1(disp[3], memory[A_SPRITE1Y     ]);
            hex1(disp[4], memory[A_SPRITE2X     ]);
            hex1(disp[5], memory[A_SPRITE2Y     ]);
            hex1(disp[6], memory[A_SPRITE3X     ]);
            hex1(disp[7], memory[A_SPRITE3Y     ]);
            printf
            (   "SPRITE0X,Y:  %s,%s SPRITE1X,Y:  %s,%s SPRITE2X,Y:  %s,%s SPRITE3X,Y:  %s,%s\n",
                 disp[0], disp[1], disp[2], disp[3], disp[4], disp[5], disp[6], disp[7]
            );

            hex1(disp[0], memory[A_P1PADDLE     ]);
            hex1(disp[1], memory[A_P1LEFTKEYS   ]);
            hex1(disp[2], memory[A_P1MIDDLEKEYS ]);
            hex1(disp[3], memory[A_P1RIGHTKEYS  ]);
            printf
            (   "P1PADDLE:       %s P1LEFTKEYS:     %s P1MIDDLEKEYS:   %s P1RIGHTKEYS:    %s\n",
                 disp[0], disp[1], disp[2], disp[3]
            );

            hex1(disp[0], memory[A_P2PADDLE     ]);
            hex1(disp[1], memory[A_P2LEFTKEYS   ]);
            hex1(disp[2], memory[A_P2MIDDLEKEYS ]);
            hex1(disp[3], memory[A_P2RIGHTKEYS  ]);
            hex1(disp[4], memory[A_P2PALLADIUM  ]);
            printf
            (   "P2PADDLE:       %s P2LEFTKEYS:     %s P2MIDDLEKEYS:   %s P2RIGHTKEYS:    %s\n",
                 disp[0], disp[1], disp[2], disp[3]
            );

        hex1(disp[0], memory[A_P1PALLADIUM  ]);
        hex1(disp[1], memory[A_P2PALLADIUM  ]);
        printf
        (   "P1PALLADIUM:    %s P2PALLADIUM:    %s\n\n",
            disp[0],
            disp[1]
        );
    } else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        hex1(disp[0], memory[I_CONSOLE      ]);
        hex1(disp[1], memory[I_PITCH        ]);
        hex1(disp[2], memory[I_NOISE        ]);
        hex1(disp[3], memory[I_SIZES        ]);
        printf
        (   "CONSOLE:        %s PITCH:          %s NOISE:          %s SIZES:          %s\n",
            disp[0],           disp[1],           disp[2],           disp[3]
        );

        hex1(disp[0], memory[I_SCORECTRL    ]);
        hex1(disp[1], memory[I_SCORELT      ]);
        hex1(disp[2], memory[I_SCORERT      ]);
        hex1(disp[3], memory[I_BGCOLOUR     ]);
        printf
        (   "SCORECTRL:      %s SCORELT:        %s SCORERT:        %s BGCOLOUR:       %s\n",
            disp[0],           disp[1],           disp[2],           disp[3]
        );

        hex1(disp[0], memory[I_BGCOLLIDE    ]);
        hex1(disp[1], memory[I_SPRITECOLLIDE]);
        hex1(disp[2], memory[I_SPR01COLOURS ]);
        hex1(disp[3], memory[I_SPR23COLOURS ]);
        printf
        (   "BGCOLLIDE:      %s SPRITECOLLIDE:  %s SPR01COLOURS:   %s SPR23COLOURS:   %s\n",
            disp[0],           disp[1],           disp[2],           disp[3]
        );

        hex1(disp[0], memory[I_SPRITE0AX    ]);
        hex1(disp[1], memory[I_SPRITE0AY    ]);
        hex1(disp[2], memory[I_SPRITE1AX    ]);
        hex1(disp[3], memory[I_SPRITE1AY    ]);
        hex1(disp[4], memory[I_SPRITE2AX    ]);
        hex1(disp[5], memory[I_SPRITE2AY    ]);
        hex1(disp[6], memory[I_SPRITE3AX    ]);
        hex1(disp[7], memory[I_SPRITE3AY    ]);
        printf
        (   "SPRITE0AX,Y: %s,%s SPRITE1AX,Y: %s,%s SPRITE2AX,Y1 %s,%s SPRITE3AX,Y: %s,%s\n",
            disp[0], disp[1], disp[2], disp[3], disp[4], disp[5], disp[6], disp[7]
        );

        hex1(disp[0], memory[I_SPRITE0BX    ]);
        hex1(disp[1], memory[I_SPRITE0BY    ]);
        hex1(disp[2], memory[I_SPRITE1BX    ]);
        hex1(disp[3], memory[I_SPRITE1BY    ]);
        hex1(disp[4], memory[I_SPRITE2BX    ]);
        hex1(disp[5], memory[I_SPRITE2BY    ]);
        hex1(disp[6], memory[I_SPRITE3BX    ]);
        hex1(disp[7], memory[I_SPRITE3BY    ]);
        printf
        (   "SPRITE0BX,Y: %s,%s SPRITE1BX,Y: %s,%s SPRITE2BX,Y: %s,%s SPRITE3BX,Y: %s,%s\n",
            disp[0], disp[1], disp[2], disp[3], disp[4], disp[5], disp[6], disp[7]
        );

        hex1(disp[0], memory[I_P1PADDLE     ]);
        hex1(disp[1], memory[I_P1LEFTKEYS   ]);
        hex1(disp[2], memory[I_P1MIDDLEKEYS ]);
        hex1(disp[3], memory[I_P1RIGHTKEYS  ]);
        printf
        (   "P1PADDLE:       %s P1LEFTKEYS:     %s P1MIDDLEKEYS:   %s P1RIGHTKEYS:    %s\n",
            disp[0], disp[1], disp[2], disp[3]
        );

        hex1(disp[0], memory[I_P2PADDLE     ]);
        hex1(disp[1], memory[I_P2LEFTKEYS   ]);
        hex1(disp[2], memory[I_P2MIDDLEKEYS ]);
        hex1(disp[3], memory[I_P2RIGHTKEYS  ]);
        printf
        (   "P2PADDLE:       %s P2LEFTKEYS:     %s P2MIDDLEKEYS:   %s P2RIGHTKEYS:    %s\n\n",
             disp[0], disp[1], disp[2], disp[3]
        );
    }

    REACTIVATE;
}

EXPORT void view_udcs(void)
{   int i, j, k;

    OPENCONSOLE;

    if (machine == ARCADIA)
    {   for (i = 0; i < 4; i++)
        {   for (j = 0; j < 8; j++)
            {   for (k = 0; k < 8; k++)
                {   if (memory[A_OFFSET_SPRITES + (i * 8) + j] & (0x80 >> k))
                    {   bits[i][j][k] = '#';
                    } else
                    {   bits[i][j][k] = '.';
                }   }
                bits[i][j][8] = 0;
        }   }

        printf
        (   "SPRITE0: %s SPRITE1: %s SPRITE2: %s SPRITE3: %s\n",
            bits[0][0], bits[1][0], bits[2][0], bits[3][0]
        );
        for (i = 1; i < 8; i++)
        {   printf
            (   "         %s          %s          %s          %s\n",
                bits[0][i], bits[1][i], bits[2][i], bits[3][i]
            );
        }

        for (i = 4; i < 8; i++)
        {   for (j = 0; j < 8; j++)
            {   for (k = 0; k < 8; k++)
                {   if (memory[A_OFFSET_SPRITES + (i * 8) + j] & (0x80 >> k))
                    {   bits[i - 4][j][k] = (TEXT) '#';
                    } else
                    {   bits[i - 4][j][k] = (TEXT) '.';
                }   }
                bits[i - 4][j][8] = 0;
        }   }

        printf
        (   "\n   UDC0: %s    UDC1: %s    UDC2: %s    UDC3: %s\n",
            bits[0][0], bits[1][0], bits[2][0], bits[3][0]
        );
        for (i = 1; i < 8; i++)
        {   printf
            (   "         %s          %s          %s          %s\n",
                bits[0][i], bits[1][i], bits[2][i], bits[3][i]
            );
    }   }
    else
    {   // assert(machine == INTERTON);

        for (i = 0; i < 4; i++)
        {   for (j = 0; j < 10; j++)
            {   for (k = 0; k < 8; k++)
                {   if (memory[i_spritedata[i] + j] & (0x80 >> k))
                    {   bits[i][j][k] = '#';
                    } else
                    {   bits[i][j][k] = '.';
                }   }
                bits[i][j][8] = 0;
        }   }

        printf
        (   "SPRITE0: %s SPRITE1: %s SPRITE2: %s SPRITE3: %s\n",
            bits[0][0], bits[1][0], bits[2][0], bits[3][0]
        );
        for (i = 1; i < 10; i++)
        {   printf
            (   "         %s          %s          %s          %s\n",
                bits[0][i], bits[1][i], bits[2][i], bits[3][i]
            );
    }   }
          
    printf("\n");
    REACTIVATE;
}

EXPORT FLAG parse_bytes(FLAG loading)
{   UBYTE kind;
    UWORD loadaddress;
    int   i,
          version = 0; // initialized to avoid spurious compiler warnings
    FLAG  found = FALSE;

    // assert(!crippled);
    // assert(!inframe);

    overcalc = 0; // signed

/* EAS/EAR files are (offsets shown for V2):
        0:  magic byte    (  1 byte  ) ($10 for EAS, $11 for EAR)
   1.. 30:  CPU state     ( 30 bytes )
       31:  version ID    (  1 byte  ) (2)
       32:  overcalc      (  1 byte  )
  33..625:  UVI/RAM dump  (593 bytes )
      626+: ROM dump
    after+: recording     (EAR only  )
Supported EAS/EAR versions are 1 (V4.2+) and 2 (V4.32+).

INS/INR files are (offsets shown for V3):
        0:  magic byte    (   1 byte ) ($B6 for INS, $B7 for INR)
   1.. 30:  CPU state     (  30 bytes)
       31:  version ID    (   1 byte ) (3)
       32:  overcalc      (   1 byte ) (V3+ only)
 33..3261:  PVI/RAM dump  (3229 bytes)
     3262+: ROM dump
    after+: recording     (INR only  )
Supported INS/INR versions are 2 (V4.0+) and 3 (V4.32+).

TVS/TVR files are (offsets shown for V3):
        0:  magic byte    (  1 byte  ) ($90 for TVS, $91 for TVR)
   1.. 30:  CPU state     ( 30 bytes )
       31:  version ID    (  1 byte  ) (3)
       32:  overcalc      (  1 byte  ) (V3+ only)
  33.. 34:  whichgame     (  2 bytes ) (V2+ only)
 35..6178:  PVI/RAM dump  (6144 bytes)
     6179+: recording     (TVR only  )
Supported TVS/TVR versions are 1 (V4.2+), 2 (V4.3+) and 3 (V4.32+).

There is EAS/EAR/INS/INR/TVS/TVR backwards compatibility to at least V4.2.
There is configuration file backwards compatibility to V4.27.

TVC files are:
        0:  magic byte    (always $02)
     1..2:  load address  (where to load program to)
     3..4:  start address (where to point IAR to)
        5+: the program itself */

    // magic byte
    switch(IOBuffer[0])
    {
    case 0x00:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as PGM.\n", thefilename); REACTIVATE;
#endif
        kind = KIND_PGM;
        machine = ELEKTOR;
        romsize = filesize;
        iar = 0x900;
        offset = 0; // for autosense()
    acase 0x02:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as TVC.\n", thefilename); REACTIVATE;
#endif
        kind = KIND_TVC;
        machine = ELEKTOR;
        offset = 1;
        romsize = filesize;
        iar = 0;
    acase 0x10:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as EAS.\n", thefilename); REACTIVATE;
#endif
		offset = 31;
	    version = ReadByte();
        if (version < 1 || version > 2)
        {   say("Unsupported EAS version!");
            return FALSE;
        }
        kind = KIND_EAS;
        machine = ARCADIA;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 626; // for autosense()
        } else
        {   // assert(version == 2);
            offset = 625; // for autosense()
        }
    acase 0x11:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as EAR.\n", thefilename); REACTIVATE;
#endif
		offset = 31;
	    version = ReadByte();
        if (version < 1 || version > 2)
        {   say("Unsupported EAR version!");
            return FALSE;
        }
        kind = KIND_EAR;
        machine = ARCADIA;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 626; // for autosense()
        } else
        {   // assert(version == 2);
            offset = 625; // for autosense()
        }
    acase 0x90:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as TVS.\n", thefilename); REACTIVATE;
#endif
		offset = 31;
	    version = ReadByte();
        if (version < 1 || version > 3)
        {   say("Unsupported TVS version!");
            return FALSE;
        }
        kind = KIND_TVS;
        machine = ELEKTOR;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 33;
        } elif (version == 2)
        {   offset = 32;
        } /* offset is unimportant for V1 files (dead assignment) */
    acase 0x91:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as TVR.\n", thefilename); REACTIVATE;
#endif
		offset = 31;
	    version = ReadByte();
        if (version < 1 || version > 3)
        {   say("Unsupported TVR version!");
            return FALSE;
        }
        kind = KIND_TVR;
        machine = ELEKTOR;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 33;
        } elif (version == 2)
        {   offset = 32;
        } /* offset is unimportant for V1 files (dead assignment) */
    acase 0xB6:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as INS.\n", thefilename); REACTIVATE;
#endif
        offset = 31;
        version = ReadByte();
        if (version < 2 || version > 3)
        {   say("Unsupported INS version!");
            return FALSE;
        }
        kind = KIND_INS;
        machine = INTERTON;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 3262; // for autosense()
        } else
        {   // assert(version == 2);
            offset = 3261; // for autosense()
        }
    acase 0xB7:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as INR.\n", thefilename); REACTIVATE;
#endif
        offset = 31;
        version = ReadByte();
        if (version < 2 || version > 3)
        {   say("Unsupported INS version!");
            return FALSE;
        }
        kind = KIND_INR;
        machine = INTERTON;
        offset = 1;
        romsize = ReadInt();
        if (version == 3)
        {   offset = 3262; // for autosense()
        } else
        {   // assert(version == 2);
            offset = 3261; // for autosense()
        }
    adefault:
#ifdef VERBOSE
        OPENCONSOLE; printf("Loading %s as BIN.\n", thefilename); REACTIVATE;
#endif
        kind = KIND_BIN;
        if (machine == ELEKTOR) // shouldn't normally happen
        {   machine = INTERTON; // hopefully it's an Interton ROM :-)
        }
        romsize = filesize;
        iar = 0;
        offset = 0; // for autosense()
    break;
    }

    if (machine == ARCADIA)
    {   arcadia();
    } elif (machine == INTERTON)
    {   interton();
    } else
    {   // assert(machine == ELEKTOR);
        elektor();
    }
    // those need to be above these
    if (loading)
    {   downframes  = 4;
        totalframes = 16;
        primary     = 2;
        fudge       = FUDGE;
        cpl         = PVI_CPL;
        whichgame   = -1;

		if (sensegame != SENSEGAME_NO)
        {   // assert(sensegame == SENSEGAME_VERBOSE || sensegame == SENSEGAME_QUIET);
			if
            (   kind == KIND_TVS
             || kind == KIND_TVR
            )
            {   if (version >= 2)
                {   whichgame = ReadInt();
            	    found = TRUE;
					if (whichgame >= 0 && whichgame < KNOWNGAMES)
                    {   configure();
				}   }
				else
				{   whichgame = -1;
			}	}
            elif
            (   kind == KIND_BIN
             || kind == KIND_EAS
             || kind == KIND_EAR
             || kind == KIND_INS
             || kind == KIND_INR
             || kind == KIND_PGM
            )
            {   found = autosense();
    }   }   }

    if
    (   kind == KIND_EAS
     || kind == KIND_EAR
     || kind == KIND_INS
     || kind == KIND_INR
     || kind == KIND_TVS
     || kind == KIND_TVR
    )
    {   offset = 1;
        // CPU state (30 bytes)
        romsize = ReadInt();            //  1.. 2
        iar     = (UWORD) ReadInt();    //  3.. 4
        page    = (UWORD) ReadByte();   //      5
        psu     = ReadByte();           //      6
        psl     = ReadByte();           //      7

        for (i = 0; i < 8; i++)
        {   ras[i] = (UWORD) ReadInt(); //  8..23
        }
        for (i = 0; i < 7; i++)
        {   r[i] = ReadByte();          // 24..30
        }

        assert(offset == 31);
        version = ReadByte(); // version ID

        // XVI/RAM areas
        if (machine == ARCADIA)
        {   if (version >= 2)
            {   overcalc = ReadByte();
            }

            for (i = 0x1800; i <= 0x1908; i++) /* 265 bytes */ memory[i] = ReadByte();
            for (i = 0x1980; i <= 0x19BF; i++) /*  64 bytes */ memory[i] = ReadByte();
            for (i = 0x19F8; i <= 0x1AFF; i++) /* 264 bytes */ memory[i] = ReadByte();
                                             /* = 593 bytes */
        } elif (machine == INTERTON)
        {   if (version >= 3)
            {   overcalc = ReadByte();
            }

            for (i = 0x1000; i <= 0x15FF; i++)                 memory[i] = ReadByte();
            for (i = 0x1800; i <= 0x1DFF; i++)                 memory[i] = ReadByte();
            for (i = 0x1E88; i <= 0x1E8E; i++) /*   7 bytes */ memory[i] = ReadByte();
            for (i = 0x1F00; i <= 0x1F2D; i++) /*  46 bytes */ memory[i] = ReadByte();
            for (i = 0x1F40; i <= 0x1F6D; i++) /*  46 bytes */ memory[i] = ReadByte();
            for (i = 0x1F80; i <= 0x1FAD; i++) /*  46 bytes */ memory[i] = ReadByte();
            for (i = 0x1FC0; i <= 0x1FC3; i++) /*   4 bytes */ memory[i] = ReadByte();
            for (i = 0x1FC6; i <= 0x1FCD; i++) /*   8 bytes */ memory[i] = ReadByte();
        } else
        {   // assert(machine == ELEKTOR);

            if (version >= 3)
            {   overcalc = ReadByte();
            }
            if (version >= 2)
            {   DISCARD ReadInt(); // whichgame
			}

            for (i =  0x800; i <= 0x1FFF; i++) /*   6K      */ memory[i] = ReadByte();
    }   }

    if (kind == KIND_PGM)
    {   offset = 0x8C0;
        for (i = 0x8C0; i < romsize; i++)
        {   memory[i] = ReadByte();
        }

        // memory[$1FC0..$1FC9] = memory[$177..$180]
        // ie.:
        //  SIZES        = $AA
        //  SPR01COLOURS = $09
        //  SPR23COLOURS = $09
        //  SCORECTRL    = $00
        //  $1FC4        = $00
        //  $1FC5        = $00
        //  BGCOLOUR     = $19
        //  PITCH        = $00
        //  SCORELT      = $AA
        //  SCORERT      = $AA
        for (i = 0; i < 10; i++)
        {   memory[0x1FC0 + i] = memory[0x177 + i];
        }

        offset = 1;
        memory[0x8BE] = ReadByte();
        memory[0x8BF] = ReadByte();
    } elif (kind == KIND_TVC)
    {   // assert(offset == 1);
        loadaddress = ReadInt();
        offset = 5;
#ifdef VERBOSE
        OPENCONSOLE;
#endif
        for (i = 0; i < romsize - 5; i++)
        {   memory[loadaddress + i] = ReadByte();
#ifdef VERBOSE
            printf("Loading $%lX with $%lX.\n", loadaddress + i, memory[loadaddress + i]);
#endif
        }

        // memory[$1FC0..$1FC9] = memory[$177..$180]
        // ie.:
        //  SIZES        = $AA
        //  SPR01COLOURS = $09
        //  SPR23COLOURS = $09
        //  SCORECTRL    = $00
        //  $1FC4        = $00
        //  $1FC5        = $00
        //  BGCOLOUR     = $19
        //  PITCH        = $00
        //  SCORELT      = $AA
        //  SCORERT      = $AA
        for (i = 0; i < 10; i++)
        {   memory[0x1FC0 + i] = memory[0x177 + i];
        }

        offset = 3;
        memory[0x8BE] = ReadByte();
        memory[0x8BF] = ReadByte();
#ifdef VERBOSE
        printf("Load  address is $%lX.\n", loadaddress);
        printf("Start address is $%lX.\n", (memory[0x8BE] * 256) + memory[0x8BF]);
        REACTIVATE;
#endif
    } elif
    (   kind == KIND_BIN
     || kind == KIND_EAS
     || kind == KIND_EAR
     || kind == KIND_INS
     || kind == KIND_INR
    )
    {   if (romsize <= 2048)
        {   for (i = 0; i < romsize; i++)
            {   memory[i] = ReadByte();              // $0000..$07FF -> $0000..$07FF
            }
            if (machine == INTERTON && !found)
            {   memmap = MEMMAP_A;
#ifdef VERBOSE
                OPENCONSOLE;
                printf("Configuring as type \"A\" (2K ROM + 0K RAM).\n");
                REACTIVATE;
#endif
        }   }
        elif (romsize <= 4096)
        {   for (i = 0; i < romsize; i++)
            {   memory[i] = ReadByte();              // $0000..$0FFF -> $0000..$0FFF
            }
            if (machine == INTERTON && !found)
            {   memmap = MEMMAP_C; // could be B or C, C is generally safer
#ifdef VERBOSE
                OPENCONSOLE;
                printf("Configuring as type \"C\" (4K ROM + 1K RAM).\n");
                REACTIVATE;
#endif
        }   }
        elif (romsize <= 8192)
        {   if (machine == ARCADIA)
            {   for (i = 0; i < 4096; i++)
                {   memory[i] = ReadByte();              // $0000..$0FFF -> $0000..$0FFF
                }
                for (i = 0; i < romsize - 4096; i++)
                {   memory[0x2000 + i] = ReadByte();     // $1000..$1FFF -> $2000..$2FFF
            }   }
            else
            {   // assert(machine == INTERTON);
                for (i = 0; i < romsize; i++)
                {   memory[i] = ReadByte();              // $0000..$17FF -> $0000..$17FF (but $1600..$17FF is inaccessible)
                }
                if (!found)
                {   memmap = MEMMAP_D;
                }
#ifdef VERBOSE
                OPENCONSOLE;
                printf("Configuring as type \"D\" (6K ROM + 1K RAM).\n");
                REACTIVATE;
#endif
        }   }
        elif (romsize <= 12 * KILOBYTE)
        {   // assert(machine == ARCADIA);
            for (i = 0; i < 4096; i++)
            {   memory[i] = ReadByte();              // $0000..$0FFF -> $0000..$0FFF
            }
            for (i = 0; i < 4096; i++)
            {   memory[0x2000 + i] = ReadByte();     // $1000..$1FFF -> $2000..$2FFF
            }
            for (i = 0; i < romsize - 8192; i++)
            {   memory[0x4000 + i] = ReadByte();     // $2000..$2FFF -> $4000..$4FFF
        }   }
        else
        {   // assert(romsize <= 16 * KILOBYTE);
            // assert(machine == ARCADIA);
            for (i = 0; i < 4096; i++)
            {   memory[i] = ReadByte();          // $0000..$0FFF -> $0000..$0FFF
            }
            for (i = 0; i < 4096; i++)
            {   memory[0x2000 + i] = ReadByte(); // $1000..$1FFF -> $2000..$2FFF
            }
            for (i = 0; i < 4096; i++)
            {   memory[0x4000 + i] = ReadByte(); // $2000..$2FFF -> $4000..$4FFF
            }
            for (i = 0; i < romsize - (12 * KILOBYTE); i++)
            {   memory[0x6000 + i] = ReadByte(); // $3000..$3FFF -> $6000..$6FFF
        }   }
        if (golf)
        {   // This is for (unpatched) GOLF.BIN (Arcadia not Interton)
            // It mirrors $2000..$27FF at $4000..$47FF
            for (i = 0; i < 2048; i++)
            {   memory[0x4000 + i] = memory[0x2000 + i];
    }   }   }

    if
    (   kind == KIND_BIN
     || kind == KIND_PGM
     || kind == KIND_TVC
     || kind == KIND_EAS
     || kind == KIND_INS
     || kind == KIND_TVS
    )
    {   free_iobuffer();
        recmode   = RECMODE_NORMAL;
    } elif
    (   kind == KIND_EAR
     || kind == KIND_INR
     || kind == KIND_TVR
    )
    {   recmode   = RECMODE_PLAY;
        recsize   = filesize;
    } // else assert(0);
    updatemenus();
    updatesmlgads();

    interrupt = FALSE;
    frames    =
    oldframes =
    cycles    =
    elapsed   = 0; // unsigned

    game = TRUE;
    if (machine == ELEKTOR)
    {   if (kind == KIND_PGM || kind == KIND_TVC)
        {   iar = (memory[0x8BE] * 256) + memory[0x8BF]; // set page also?
            page = (UWORD) iar & PAGE;
            iar =  (UWORD) iar & ~(PAGE);
#ifdef VERBOSE
            OPENCONSOLE; printf("Setting IAR to $%lX.\n", iar); REACTIVATE;
#endif
    }   }
    if (kind == KIND_BIN)
    {   iar = 0;
    }

    return TRUE;
}

EXPORT void docommand(int which)
{   switch(which)
    {
    case MENUITEM_DEMULTIPLEX:
        updatesmlgad(GADPOS_DEMULTIPLEX, demultiplex, TRUE);
        updatemenu(MENUITEM_DEMULTIPLEX);
        if (emulating && paused)
        {   redrawscreen();
        }
    acase MENUITEM_LOGINSTRUCTIONS:
        updatemenu(MENUITEM_LOGINSTRUCTIONS);
    acase MENUITEM_LOOP:
        updatemenu(MENUITEM_LOOP);
    acase MENUITEM_POINTER:
        updatemenu(MENUITEM_POINTER);
        if (showpointer)
#ifdef AMIGA
            ClearPointer(MainWindowPtr);
#endif
#ifdef WIN32
            ShowCursor(TRUE);
#endif
        else
#ifdef AMIGA
            SetPointer(MainWindowPtr, PointerData, 1, 1, 0, 0);
#endif
#ifdef WIN32
            ShowCursor(FALSE);
#endif
    acase MENUITEM_SAVEROM:
        if (emulating)
        {   if (machine == ELEKTOR)
            {   DISCARD project_save(KIND_PGM);
            } else
            {   // assert(machine == ARCADIA || machine == INTERTON);
                DISCARD project_save(KIND_BIN);
        }   }
    acase MENUITEM_SOUND:
        updatesmlgad(GADPOS_SOUND, sound, TRUE);
        updatemenu(MENUITEM_SOUND);
        if (sound)
        {   sound_on();
        } else
        {   sound_off();
        }
    acase MENUITEM_STEP:
        if (emulating)
        {   step = TRUE;
            unpause();
        }
        // updatemenu(MENUITEM_STEP); not required here
    acase MENUITEM_TRACECPU:
        updatemenu(MENUITEM_TRACECPU);
    acase MENUITEM_TITLEBAR:
        updatemenu(MENUITEM_TITLEBAR);
#ifdef AMIGA
        ShowTitle(ScreenPtr, showtitlebar);
#endif
#ifdef WIN32
        closewindow();
        if (showtitlebar && !fullscreen)
        {   // wintopy -= titleheight + 4;
            winleftx -= 4;
        }
        openwindow(FALSE);
        redrawscreen();
    acase MENUITEM_TOOLBAR:
        updatemenu(MENUITEM_TOOLBAR);
        closewindow();
        if (showtoolbar && !fullscreen)
        {   // wintopy -= TOOLBARHEIGHT + 14;
            winleftx -= 6;
        }
        openwindow(FALSE);
        redrawscreen();
#endif
    acase COMMAND_ARCADIA:
        if (machine != ARCADIA)
        {   strcpy(thefilename, pathpart);
            arcadia();
            updatemenus();
            updatebiggads();
            updatesmlgads();
            settitle();
            redrawscreen();
        }
    acase COMMAND_ELEKTOR:
        if (machine != ELEKTOR)
        {   strcpy(thefilename, pathpart);
            elektor();
            updatemenus();
            updatebiggads();
            updatesmlgads();
            settitle();
            redrawscreen();
        }
    acase COMMAND_INTERTON:
        if (machine != INTERTON)
        {   strcpy(thefilename, pathpart);
            interton();
            updatemenus();
            updatebiggads();
            updatesmlgads();
            settitle();
            redrawscreen();
        }
    acase COMMAND_REGION:
        updatesmlgad(GADPOS_REGION, region, TRUE);
        updatemenu(MENUITEM_REGION);
    adefault:
        // assert(0);
    break;
}   }

EXPORT void fixextension_load(STRPTR extension)
{   int length;

    length = (int) strlen(thefilename);
    if
    (   length >= 5
     && stricmp(&thefilename[length - 4], ".BIN")
     && stricmp(&thefilename[length - 4], ".EAS")
     && stricmp(&thefilename[length - 4], ".EAR")
     && stricmp(&thefilename[length - 4], ".INS")
     && stricmp(&thefilename[length - 4], ".INR")
     && stricmp(&thefilename[length - 4], ".PGM")
     && stricmp(&thefilename[length - 4], ".TVC")
     && stricmp(&thefilename[length - 4], ".TVS")
     && stricmp(&thefilename[length - 4], ".TVR")
    )
    {   strcat(thefilename, extension); // add extension
}   }

EXPORT void fixextension_save(int kind)
{   int length;

    length = (int) strlen(filepart);
    if (length >= 5)
    {   if (    kind == KIND_EAS && stricmp(&filepart[length - 4], ".EAS"))
        {   strcpy(&filepart[length - 4], ".EAS");
        } elif (kind == KIND_INS && stricmp(&filepart[length - 4], ".INS"))
        {   strcpy(&filepart[length - 4], ".INS");
        } elif (kind == KIND_TVS && stricmp(&filepart[length - 4], ".TVS"))
        {   strcpy(&filepart[length - 4], ".TVS");
        } elif (kind == KIND_EAR && stricmp(&filepart[length - 4], ".EAR"))
        {   strcpy(&filepart[length - 4], ".EAR");
        } elif (kind == KIND_INR && stricmp(&filepart[length - 4], ".INR"))
        {   strcpy(&filepart[length - 4], ".INR");
        } elif (kind == KIND_TVR && stricmp(&filepart[length - 4], ".TVR"))
        {   strcpy(&filepart[length - 4], ".TVR");
        } elif (kind == KIND_PGM && stricmp(&filepart[length - 4], ".PGM"))
        {   strcpy(&filepart[length - 4], ".PGM");
        } elif (kind == KIND_TVC && stricmp(&filepart[length - 4], ".TVC"))
        {   strcpy(&filepart[length - 4], ".TVC");
        } elif (kind == KIND_BIN && stricmp(&filepart[length - 4], ".BIN"))
        {   strcpy(&filepart[length - 4], ".BIN");
}   }   }

// this routine reads but doesn't write offset
MODULE FLAG autosense(void)
{   AUTO    ULONG crc32;
    AUTO    int   i;

    golf = FALSE;
    crc32 = getcrc32(IOBuffer + offset);
#ifdef VERBOSE
    OPENCONSOLE; printf("ROM size: %ld. CRC32: $%lX.\n", romsize, crc32); REACTIVATE;
#endif
    for (i = 0; i < KNOWNGAMES; i++)
    {   if (romsize == known[i].size * KILOBYTE && crc32 == known[i].crc32)
        {   whichgame = i;
            configure();
            return TRUE; // for speed
    }   }

#ifdef VERBOSE
    OPENCONSOLE; printf("Unknown game.\n"); REACTIVATE;
#endif

    return FALSE;
}

MODULE void configure(void)
{   PERSIST TEXT saystring[256 + 1];

    machine     = (int)   known[whichgame].machine;
    autofire    = (ULONG) known[whichgame].autofire;
    analog      = (ULONG) known[whichgame].analog;
    demultiplex = (ULONG) known[whichgame].demultiplex;
    swapped     = (ULONG) known[whichgame].swapped;
    memmap      = (int)   known[whichgame].memmap;
    downframes  = (int)   known[whichgame].downframes;
    totalframes = (int)   known[whichgame].totalframes;
    // upframes = totalframes - downframes;
    primary     = (int)   known[whichgame].primary;
    flagline    = (ULONG) known[whichgame].flagline;
    if (usehacks)
    {   fudge   = (int)   known[whichgame].fudge;
        cpl     = (int)   known[whichgame].cpl;
    }

#ifdef VERBOSE
    OPENCONSOLE; printf("Autosensed game %ld.\n", i); REACTIVATE;
#endif

    if (machine == ARCADIA && romsize == 6144 && whichgame == GOLFPOS)
    {   golf = TRUE;
    } else
    {   golf = FALSE;
    }

    if (sensegame == SENSEGAME_VERBOSE)
    {   strcpy(saystring, known[whichgame].name);
        if (known[whichgame].bad)
        {   strcat(saystring, " (bad dump)");
        }
        strcat(saystring, "\n");
        if (machine == ARCADIA)
        {   strcat(saystring, "Emerson Arcadia 2001");
        } elif (machine == INTERTON)
        {   strcat(saystring, "Interton VC 4000, type \"");
            if (memmap == MEMMAP_A)
            {   strcat(saystring, "A\" (2K ROM + 0");
            } elif (memmap == MEMMAP_B)
            {   strcat(saystring, "B\" (4K ROM + 0");
            } elif (memmap == MEMMAP_C)
            {   strcat(saystring, "C\" (4K ROM + 1");
            } else
            {   // assert(memmap == MEMMAP_D);
                strcat(saystring, "D\" (6K ROM + 1");
            }
            strcat(saystring, "K RAM)");
        } else
        {   // assert(machine == ELEKTOR);
            strcat(saystring, "Elektor TV Games Computer");
        }
        sprintf(&saystring[strlen(saystring)], "\n%ldK", (int) known[whichgame].size);
        // final \n not needed
        infowindow(saystring);
}   }

MODULE ULONG getcrc32(UBYTE* address)
{   register ULONG crc;
             int   i;

    crc = 0xFFFFFFFF;
    for (i = 0; i < romsize; i++)
    {   crc = ((crc >> 8) & 0x00FFFFFF) ^ crcTable[(crc ^ *address++) & 0xFF];
    }
    return(crc ^ 0xFFFFFFFF);
}

EXPORT void generate_crctable(void)
{   ULONG crc;
    int   i, j;

    for (i = 0; i < 256; i++)
    {   crc = i;
        for (j = 8; j > 0; j--)
        {   if (crc & 1)
            {   crc = (crc >> 1) ^ 0xEDB88320L;
            } else
            {   crc >>= 1;
        }   }
        crcTable[i] = crc;
}   }

EXPORT void runto(void)
{   if (inframe && !crippled)
    {   cripple();
    }
    pause();

#ifdef WIN32
    updatemonitor();
#endif

    updatescreen();

    // assert(crippled);
    while (paused)
    {   checkinput();
}   }

EXPORT void hex1(char* out, UBYTE value)
{   ULONG digit;

    digit = value / 16;
    if (digit <= 9)
    {   *(out) = (char) ('0' + digit);
    } else
    {   *(out) = (char) ('A' + digit - 10);
    }

    digit = value % 16;
    if (digit <= 9)
    {   *(out + 1) = (char) ('0' + digit);
    } else
    {   *(out + 1) = (char) ('A' + digit - 10);
    }

    *(out + 2) = 0;
}

EXPORT void hex2(char* out, UWORD value)
{   ULONG digit;

    digit = value / 4096;
    if (digit <= 9)
    {   *(out) = (char) ('0' + digit);
    } else
    {   *(out) = (char) ('A' + digit - 10);
    }

    digit = (value % 4096) / 256;
    if (digit <= 9)
    {   *(out + 1) = (char) ('0' + digit);
    } else
    {   *(out + 1) = (char) ('A' + digit - 10);
    }

    digit = (value % 256) / 16;
    if (digit <= 9)
    {   *(out + 2) = (char) ('0' + digit);
    } else
    {   *(out + 2) = (char) ('A' + digit - 10);
    }

    digit = value % 16;
    if (digit <= 9)
    {   *(out + 3) = (char) ('0' + digit);
    } else
    {   *(out + 3) = (char) ('A' + digit - 10);
    }

    *(out + 4) = 0;
}

EXPORT void decimal(char* out, unsigned long value)
{   ULONG calc,
          i,
          where   = 0;
    FLAG  started = FALSE;

    for (i = ONE_BILLION; i >= 1; i /= 10)
    {   calc = value / i;
        // assert(calc < 10);
        if (calc || started || i == 1)
        {   *(out + where) = (char) ('0' + calc);
            started = TRUE;
        } else
        {   *(out + where) = ' ';
        }
        where++;
        value %= i;
    }

    *(out + where) = 0;
}

EXPORT void engine_setup(void)
{   generate_crctable();

    timestring[2]  =
    timestring[5]  = ':';
    timestring[8]  = '.';
    timestring[11] = 0;
}
